// Copyright (C) 2012 Nanakos Chrysostomos <nanakos@wired-net.gr>
// SoftYubikey Gnome Shell Extension
const St = imports.gi.St;
const Main = imports.ui.main;
const Tweener = imports.ui.tweener;
const Shell = imports.gi.Shell;
const GLib = imports.gi.GLib;
const Util = imports.misc.util;
const Gio = imports.gi.Gio;

let text, button;
let ykey

function _hideOTP() {
    Main.uiGroup.remove_actor(text);
    text = null;
}

function _CreateOTP() {
    if (!text) {
        text = new St.Label({ style_class: 'create-otp', text: "OTP created" });
        Main.uiGroup.add_actor(text);
    }

    text.opacity = 255;
    let monitor = Main.layoutManager.primaryMonitor;
    text.set_position(Math.floor(monitor.width / 2 - text.width / 2),
                      Math.floor(monitor.height / 2 - text.height / 2));
    Tweener.addTween(text,
                     { opacity: 0,
                       time: 2,
                       transition: 'easeOutQuad',
                       onComplete: _hideOTP });
    Util.trySpawn(['python',ykey,'\n']);
}

function init(metadata) {
    button = new St.Bin({ style_class: 'panel-button',
                          reactive: true,
                          can_focus: true,
                          x_fill: true,
                          y_fill: false,
                          track_hover: true });
    let icon_file = metadata.path + "/softyubikey.png";
    let file = Gio.file_new_for_path(icon_file);
    let icon_uri = file.get_uri();
    let icon = St.TextureCache.get_default().load_uri_sync(icon_uri,50,50);
    button.set_child(icon);
    button.connect('button-press-event', _CreateOTP);
    ykey = GLib.build_filenamev([metadata.path,'ykey']);
}

function enable() {
    Main.panel._rightBox.insert_child_at_index(button, 0);
}

function disable() {
    Main.panel._rightBox.remove_child(button);
}
