const { GObject, Gtk, Gio } = imports.gi;

const ExtensionUtils = imports.misc.extensionUtils;
const Me = ExtensionUtils.getCurrentExtension();

const SCHEMA_NAME = 'org.gnome.shell.extensions.suspend-to-topbar';
const Settings = ExtensionUtils.getSettings(SCHEMA_NAME);

function init () {}

function buildPrefsWidget () {
  let widget = new PrefsWidget();
  widget.show_all();
  return widget;
}

const PrefsWidget = GObject.registerClass(
class PrefsWidget extends Gtk.Box {

  _init (params) {

    super._init(params);

    this.margin = 20;
    this.set_spacing(15);
    this.set_orientation(Gtk.Orientation.VERTICAL);

    this.connect('destroy', Gtk.main_quit);

    let askBeforeSuspendLabel = new Gtk.Label({
      label : "Ask before suspend"
    });

    let askBeforeSuspendSwitch = new Gtk.Switch();
    askBeforeSuspendSwitch.connect("notify::value", function (w) {
      log(w.get_value_as_int());
    });

    let hBox = new Gtk.Box();
    hBox.set_orientation(Gtk.Orientation.HORIZONTAL);

    hBox.pack_start(askBeforeSuspendLabel, false, false, 0);
    hBox.pack_end(askBeforeSuspendSwitch, false, false, 0);

    this.add(hBox);

    Settings.bind(
      'ask-before-suspend',
      askBeforeSuspendSwitch,
      'active',
      Gio.SettingsBindFlags.DEFAULT,
    );
  }

});