const {Gio, GObject, St} = imports.gi;
const {main, panelMenu} = imports.ui;
const SystemActions = imports.misc.systemActions;
const ExtensionUtils = imports.misc.extensionUtils;

const Mainloop = imports.mainloop;
const Gettext = imports.gettext;

const Config = imports.misc.config;
const SHELL_MINOR = parseInt(Config.PACKAGE_VERSION.split(".")[1]);
const Me = imports.misc.extensionUtils.getCurrentExtension();
const _ = Gettext.domain(Me.uuid).gettext;

const ConfirmDialog = Me.imports.confirmDialog;

let indicator = null;
let suspendTimoutId = null;

let SuspendIndicator = class SuspendIndicator extends panelMenu.Button {
  _init() {
    super._init(0.0, `Suspend Indicator`, false);

    let settings = ExtensionUtils.getSettings();

    let askBeforeSuspend = settings.get_boolean('ask-before-suspend');

    let suspend = new St.Icon({
      gicon: new Gio.ThemedIcon({name: "media-playback-pause-symbolic"}),
      style_class: "system-status-icon",
    });
    this.add_child(suspend);

    this._systemActions = new SystemActions.getDefault();
    this._onButtonPressEventId = this.connect("button-press-event", () => {
      if (askBeforeSuspend) {
        ConfirmDialog.openConfirmDialog(
          _('Suspend?'),
          _('Are you sure you want to suspend your computer?'),
          _('This will be executed immediately'),
          _('Yes'),
          _('No'),
          () => {
            suspendTimoutId = Mainloop.timeout_add(1000, () => this._systemActions.activateSuspend());
          }
        );
      } else {
        this._systemActions.activateSuspend();
      }
    });
  }

  destroy() {
    this.disconnect(this._onButtonPressEventId);
    super.destroy();
  }
};

// In gnome-shell >= 3.32 this class and several others became GObject
// subclasses. We can account for this change in a backwards-compatible way
// simply by re-wrapping our subclass in `GObject.registerClass()`
if (SHELL_MINOR > 30) {
  SuspendIndicator = GObject.registerClass(
    {GTypeName: "SuspendIndicator"},
    SuspendIndicator
  );
}

function enable() {
  indicator = new SuspendIndicator();

  main.panel.addToStatusArea(`Suspend Indicator`, indicator);
}

function disable() {
  if (indicator !== null) {
    indicator.destroy();
    indicator = null;
  }

  if (suspendTimoutId) {
      Mainloop.Source.remove(suspendTimoutId);
      suspendTimoutId = null;
  }
}
