var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));

// src/config.ts
import GLib from "gi://GLib";
var logFile = GLib.getenv("GNOMETOUCH_LOGFILE");
var devMode = ["true", "yes", "1"].includes(GLib.getenv("GNOMETOUCH_DEV_MODE") ?? "false");
var assetsGResourceFile = "assets.gresource";
var assetPath = Object.freeze({
  root: "resource:///org/gnome/shell/extensions/gnometouch",
  icon: (name) => `resource:///org/gnome/shell/extensions/gnometouch/icons/scalable/actions/${name}.svg`
});
var donationPlatforms = Object.freeze([
  {
    name: "Ko-fi",
    url: "https://ko-fi.com/mityax",
    description: "Most payment methods, one-time or recurring donations, no sign up required.",
    recommended: true
  },
  {
    name: "Patreon",
    url: "https://www.patreon.com/mityax",
    description: "Many payment methods, best for a recurring donation."
  },
  {
    name: "Buy Me A Coffee",
    url: "https://buymeacoffee.com/mityax",
    description: "Donate by card, no sign up required."
  }
]);
var feedbackPlatforms = Object.freeze([
  {
    title: "Create an Issue on GitHub",
    url: "https://github.com/mityax/gnome-touch/issues/new",
    buttonLabel: "Create Issue"
  }
  // TODO: provide this to make it show up in the settings
  //{
  //    title: 'Leave a Review on Gnome Extensions',
  //    url: 'todo',
  //    buttonLabel: 'Leave Review',
  //},
]);

// src/utils/logging.ts
import GLib2 from "gi://GLib";
import Gio from "gi://Gio";
function log(...text) {
  console.log("[gnometouch] ", ...text.map((item) => {
    if (item && item instanceof Error) {
      console.error(item, item.message || "", "\n", item.stack);
    }
    return repr(item);
  }));
  const msg = text.map((item) => {
    return item && item instanceof Error ? `Error (${item}): ` + (item.message || "") : repr(item);
  }).join(" ");
  if (logFile) {
    const stream = Gio.File.new_for_path(logFile).append_to(Gio.FileCreateFlags.NONE, null);
    stream.write_bytes(new GLib2.Bytes(`${(/* @__PURE__ */ new Date()).toISOString()}: ${msg}
`), null);
  }
  for (let cb of logCallbacks.values()) {
    cb(msg);
  }
  return msg;
}
function debugLog(...text) {
}
function repr(item) {
  if (item === "")
    return "<empty string>";
  if (typeof item === "symbol")
    return `<#${item.description}>`;
  if (["number", "string"].indexOf(typeof item) !== -1)
    return `${item}`;
  let json;
  try {
    if (typeof item === "object" || Array.isArray(item)) {
      json = JSON.stringify(item);
    }
  } catch (e) {
  }
  if (item && typeof item === "object" && item.constructor && item.constructor.name) {
    if (item instanceof Error) {
      return `<${item.constructor.name} object ${item.message ? '\u2013 "' + item.message + '"' : " (no error message)"}>`;
    } else if (json) {
      return `<${item.constructor.name} object ${json.length > 300 ? json.substring(0, 300) + " [...]" : json}>`;
    } else {
      return `<${item.constructor.name} object (not stringifyable)>`;
    }
  }
  return json || `${item}`;
}
var logCallbacks = /* @__PURE__ */ new Map();
function addLogCallback(callback) {
  const key = Date.now() + Math.random();
  logCallbacks.set(key, callback);
  return key;
}
function removeLogCallback(id) {
  logCallbacks.delete(id);
}
function assert(condition, message) {
}

// src/utils/delay.ts
import GLib3 from "gi://GLib";
var Delay = class _Delay {
  static pendingDelays = [];
  static ms(durationMs, onCancel = "nothing") {
    let timeoutHandle = null;
    let resolve;
    let reject;
    const promise = new CancellablePromise(
      (res, rej) => {
        [resolve, reject] = [res, rej];
        timeoutHandle = GLib3.timeout_add(GLib3.PRIORITY_DEFAULT, durationMs, () => {
          timeoutHandle = null;
          _Delay.pendingDelays = _Delay.pendingDelays.filter((d) => d !== promise);
          resolve(true);
          return GLib3.SOURCE_REMOVE;
        });
      },
      () => {
        if (timeoutHandle !== null) {
          GLib3.source_remove(timeoutHandle);
          _Delay.pendingDelays = _Delay.pendingDelays.filter((d) => d !== promise);
          if (onCancel === "throw")
            reject();
          else if (onCancel === "resolve")
            resolve(false);
          return true;
        }
        return false;
      }
    );
    this.pendingDelays.push(promise);
    return promise;
  }
  static s(seconds, onCancel = "nothing") {
    return _Delay.ms(seconds * 1e3, onCancel);
  }
  static min(minutes, onCancel = "nothing") {
    return _Delay.ms(minutes * 60 * 1e3, onCancel);
  }
  static h(hours, onCancel = "nothing") {
    return _Delay.ms(hours * 60 * 60 * 1e3, onCancel);
  }
  /**
   * Get a list of all pending delays.
   *
   * This function is only intended to be used to clean up pending [Delay]s when
   * the extension is being disabled; thus do not use it anywhere outside
   * [GnomeTouchExtension.disable()].
   */
  static getAllPendingDelays() {
    return [...this.pendingDelays];
  }
};
var CancellablePromise = class _CancellablePromise extends Promise {
  _onCancel;
  constructor(executor, onCancel) {
    super(executor);
    this._onCancel = onCancel;
  }
  /**
   * Returns true if the promise was cancelled successfully, false if it was already
   * resolved/rejected before.
   */
  cancel() {
    return this._onCancel();
  }
  then(onFulfilled, onRejected) {
    return new _CancellablePromise((resolve, reject) => {
      super.then(
        // @ts-ignore
        onFulfilled ? (v) => resolve(onFulfilled(v)) : null,
        onRejected ? (r) => reject(onRejected(r)) : null
      );
    }, this._onCancel);
  }
  catch(onRejected) {
    return new _CancellablePromise((resolve, reject) => {
      super.catch((r) => {
        const reason = onRejected?.(r);
        reject(reason);
        return reason ?? r;
      });
    }, this._onCancel);
  }
};

// src/utils/utils.ts
function findActorBy(topActor, test) {
  for (let child of topActor.get_children()) {
    if (test(child)) {
      return child;
    } else if (child.get_n_children()) {
      let result = findActorBy(child, test);
      if (result) {
        return result;
      }
    }
  }
  return null;
}
function findAllActorsBy(topActor, test) {
  const res = [];
  for (let child of topActor.get_children()) {
    if (test(child)) {
      res.push(child);
    } else if (child.get_n_children()) {
      res.push(...findAllActorsBy(child, test));
    }
  }
  return res;
}
function findActorByName(topActor, name) {
  return findActorBy(topActor, (a) => a.name === name);
}
function clamp(value, min, max) {
  if (max < min) {
    [min, max] = [max, min];
  }
  return Math.min(Math.max(value, min), max);
}
function randomChoice(arr) {
  return arr[Math.floor(arr.length * Math.random())];
}
function filterObject(obj, fn) {
  return Object.fromEntries(
    //@ts-ignore
    Object.entries(obj).filter(fn)
  );
}

// src/features/preferences/backend.ts
import Gio2 from "gi://Gio";
var gioSettings = null;
function initSettings(settings2) {
  gioSettings = settings2;
}
function uninitSettings() {
  gioSettings = null;
}
var Setting = class {
  key;
  defaultValue;
  constructor(key, defaultValue) {
    this.key = key;
    this.defaultValue = defaultValue;
  }
  bind(instance, property, flags = Gio2.SettingsBindFlags.DEFAULT) {
    gioSettings.bind(this.key, instance, property, flags);
  }
  connect(signal, handler) {
    console.assert(signal === "changed", "The only supported signal for now is `changed`");
    return gioSettings.connect(`${signal}::${this.key}`, () => handler(this.get()));
  }
  disconnect(signalId) {
    gioSettings.disconnect(signalId);
  }
};
var EnumSetting = class extends Setting {
  get() {
    return gioSettings.get_string(this.key);
  }
  set(value) {
    gioSettings.set_string(this.key, value);
  }
};
var BoolSetting = class extends Setting {
  get() {
    return gioSettings.get_boolean(this.key);
  }
  set(value) {
    gioSettings.set_boolean(this.key, value);
  }
};
var IntSetting = class extends Setting {
  min;
  max;
  constructor(key, defaultValue, min, max) {
    assert(min <= max);
    super(key, defaultValue);
    this.min = min;
    this.max = max;
  }
  get() {
    return gioSettings.get_int(this.key);
  }
  set(value) {
    assert(value % 1 == 0);
    assert(value >= this.min);
    assert(value <= this.max);
    gioSettings.set_int(this.key, clamp(value, this.min, this.max));
  }
};
var StringSetting = class extends Setting {
  get() {
    return gioSettings.get_string(this.key);
  }
  set(value) {
    gioSettings.set_string(this.key, value);
  }
};
var StringListSetting = class extends Setting {
  get() {
    let res;
    gioSettings.get_mapped(this.key, (value) => {
      if (value === null) {
        res = [];
      } else {
        try {
          res = JSON.parse(value.get_string()[0]);
          this._validateValue(res);
        } catch (e) {
          return false;
        }
      }
      return true;
    });
    return res;
  }
  set(value) {
    this._validateValue(value);
    gioSettings.set_string(this.key, JSON.stringify(value));
  }
  _validateValue(value) {
    if (!Array.isArray(value) || value.some((v) => typeof v !== "string")) {
      throw Error(`Invalid value for StringListSetting (not an array of strings): ${value}`);
    }
  }
};

// src/settings.ts
var settings = {
  navigationBar: {
    /**
     * Whether to enable the navigation bar feature or not.
     */
    enabled: new BoolSetting("navigation-bar-enabled", true),
    /**
     * Navigation bar mode – whether to use a small gesture navigation bar or a more old school
     * navigation bar with buttons.
     */
    mode: new EnumSetting("navigation-bar-mode", "gestures"),
    /**
     * Whether to reserve space for the navigation bar or overlay it over the work area.
     * This setting has no effect when the navigation bar mode is set to "buttons".
     */
    gesturesReserveSpace: new BoolSetting("navigation-bar-gestures-reserve-space", true),
    /**
     * Which buttons to show on the left side of the button navigation bar
     *
     * Available choices are:
     *  - "keyboard" - keyboard open button
     *  - "workspace-previous" - switch to previous workspace
     *  - "workspace-next" - switch to next workspace
     *  - "overview" - open overview
     *  - "apps" - open apps overview
     *  - "back" - navigate back
     *  - "spacer" - adds a little space between buttons
     */
    buttonsLeft: new StringListSetting("navigation-bar-buttons-left", ["keyboard"]),
    /**
     * Which buttons to show in the middle of the button navigation bar
     *
     * Available choices are:
     *  - "keyboard" - keyboard open button
     *  - "workspace-previous" - switch to previous workspace
     *  - "workspace-next" - switch to next workspace
     *  - "overview" - open overview
     *  - "apps" - open apps overview
     *  - "back" - navigate back
     *  - "spacer" - adds a little space between buttons
     */
    buttonsMiddle: new StringListSetting("navigation-bar-buttons-middle", []),
    /**
     * Which buttons to show on the right side of the button navigation bar
     *
     * Available choices are:
     *  - "keyboard" - keyboard open button
     *  - "workspace-previous" - switch to previous workspace
     *  - "workspace-next" - switch to next workspace
     *  - "overview" - open overview
     *  - "apps" - open apps overview
     *  - "back" - navigate back
     *  - "spacer" - adds a little space between buttons
     */
    buttonsRight: new StringListSetting(
      "navigation-bar-buttons-right",
      ["workspace-previous", "workspace-next", "spacer", "apps", "overview", "back"]
    )
  },
  oskKeyPopups: {
    /**
     * Whether to enable the OSK key popup feature or not.
     */
    enabled: new BoolSetting("osk-key-popups-enabled", true),
    /**
     * How long to show the OSK key popups for (in milliseconds).
     */
    duration: new IntSetting("osk-key-popups-duration", 35, 15, 250)
  },
  screenRotateUtils: {
    /**
     * Whether to show a floating screen rotate button when Gnome's auto-rotate setting is disabled,
     * and the device is physically rotated.
     *
     * Note: This has no effect if the device does not have an accelerometer.
     */
    floatingScreenRotateButtonEnabled: new BoolSetting("screen-rotate-utils-floating-screen-rotate-button-enabled", true)
  },
  notificationGestures: {
    /**
     * Whether to enable touchscreen gestures for notifications or not.
     */
    enabled: new BoolSetting("notification-gestures-enabled", true)
  },
  virtualTouchpad: {
    /**
     * Whether to enable the virtual touchpad feature or not.
     */
    enabled: new BoolSetting("virtual-touchpad-enabled", true)
  },
  donations: {
    installationData: new StringSetting("donations-installation-data", "{}")
  },
  /**
   * The initial page to show when the extension preferences are opened the next time.
   */
  initialPreferencesPage: new EnumSetting("preferences-initial-page", "default")
};

// src/utils/ui/assetIcon.ts
import Gio3 from "gi://Gio";
import GObject2 from "gi://GObject";
class AssetIcon extends Gio3.FileIcon {
  static {
    GObject2.registerClass(this);
  }
  constructor(iconName) {
    super({
      file: Gio3.File.new_for_uri(assetPath.icon(iconName))
    });
  }
}

export {
  __reExport,
  assetsGResourceFile,
  donationPlatforms,
  feedbackPlatforms,
  log,
  debugLog,
  assert,
  findActorBy,
  clamp,
  randomChoice,
  filterObject,
  Delay,
  initSettings,
  uninitSettings,
  settings,
  AssetIcon
};
