import Gio from "gi://Gio";
import FileHelpers from "./utils.js";
// language=XML
const interfaceXml = `
<node>
    <interface name="inputremapper.Control">
        <method name="stop_injecting">
            <arg type="s" name="group_key" direction="in">
            </arg>
        </method>
        <method name="get_state">
            <arg type="s" name="group_key" direction="in">
            </arg>
            <arg type="s" name="response" direction="out">
            </arg>
        </method>
        <method name="start_injecting">
            <arg type="s" name="group_key" direction="in">
            </arg>
            <arg type="s" name="preset" direction="in">
            </arg>
            <arg type="b" name="response" direction="out">
            </arg>
        </method>
        <method name="stop_all">
        </method>
        <method name="set_config_dir">
            <arg type="s" name="config_dir" direction="in">
            </arg>
        </method>
        <method name="autoload">
        </method>
        <method name="autoload_single">
            <arg type="s" name="group_key" direction="in">
            </arg>
        </method>
        <method name="hello">
            <arg type="s" name="out" direction="in">
            </arg>
            <arg type="s" name="response" direction="out">
            </arg>
        </method>
        <method name="quit">
        </method>
    </interface>
</node>`;
export class ProxyHandler {
    _proxy;
    _currentConfigDir;
    constructor(settings) {
        this._currentConfigDir = settings.configDir;
        this._proxy = getInputRemapperProxy(this._currentConfigDir);
        settings.addWatch('config-dir', 'config-dir', async (settings) => {
            this._currentConfigDir = settings.configDir;
            this._proxy = getInputRemapperProxy(settings.configDir);
        });
    }
    get proxy() {
        return this._proxy;
    }
    get currentConfigDir() {
        return this._currentConfigDir;
    }
}
function getInputRemapperProxy(configDir) {
    configDir ??= FileHelpers.getDefaultConfigPath();
    console.log(`getting input remapper proxy for config dir: ${configDir}`);
    const proxy = Gio.DBusProxy.makeProxyWrapper(interfaceXml);
    const dBusProxy = proxy(Gio.DBus.system, 'inputremapper.Control', '/inputremapper/Control');
    dBusProxy.set_config_dirSync(configDir);
    return dBusProxy;
}
export const getBusWatcher = (onRegistered, onUnregistered) => {
    const watcherId = Gio.bus_watch_name(Gio.BusType.SYSTEM, 'inputremapper.Control', Gio.BusNameWatcherFlags.NONE, onRegistered, onUnregistered);
    return {
        watcherId,
        unwatch: () => Gio.bus_unwatch_name(watcherId),
    };
};
