import Gio from 'gi://Gio';
import GLib from 'gi://GLib';
// convert Uint8Array into a literal string
function convertUint8ArrayToString(contents) {
    const decoder = new TextDecoder('utf-8');
    return decoder.decode(contents).trim();
}
export function readFile(fileHandle, delimiter = '', strip_header = false) {
    return new Promise((resolve, reject) => {
        try {
            fileHandle.load_contents_async(null, function (file, res) {
                try {
                    // grab contents of file or website
                    let buffer = file?.load_contents_finish(res)[1];
                    if (!buffer)
                        reject('No contents found');
                    // convert contents to string
                    let contents = convertUint8ArrayToString(buffer);
                    let result = [contents];
                    // split contents by delimiter if passed in
                    if (delimiter) {
                        result = contents.split(delimiter);
                        if (strip_header)
                            result.shift();
                    }
                    // return results
                    resolve(result);
                }
                catch (e) {
                    reject(e.message);
                }
            });
        }
        catch (e) {
            reject(e.message);
        }
    });
}
export function listFileObjects(fileHandle) {
    return new Promise((resolve, reject) => {
        let max_items = 125, results = [];
        try {
            fileHandle.enumerate_children_async(Gio.FILE_ATTRIBUTE_STANDARD_NAME, Gio.FileQueryInfoFlags.NONE, GLib.PRIORITY_LOW, null, function (file, res) {
                try {
                    if (!file) {
                        reject('No file found');
                        return;
                    }
                    let enumerator = file.enumerate_children_finish(res);
                    let callback = function (enumerator, res) {
                        try {
                            if (!enumerator) {
                                reject('No enumerator found');
                                return;
                            }
                            let files = enumerator.next_files_finish(res);
                            for (let i = 0; i < files.length; i++) {
                                results.push(files[i].get_attribute_as_string(Gio.FILE_ATTRIBUTE_STANDARD_NAME));
                            }
                            if (files.length == 0) {
                                enumerator.close_async(GLib.PRIORITY_LOW, null, function () { });
                                resolve(results);
                            }
                            else {
                                enumerator.next_files_async(max_items, GLib.PRIORITY_LOW, null, callback);
                            }
                        }
                        catch (e) {
                            reject(e.message);
                        }
                    };
                    enumerator.next_files_async(max_items, GLib.PRIORITY_LOW, null, callback);
                }
                catch (e) {
                    reject(e.message);
                }
            });
        }
        catch (e) {
            reject(e.message);
        }
    });
}
