import GLib from 'gi://GLib';
export class GLibExecutor {
    #event_loop = null;
    #events = new Array();
    wake(system, event) {
        this.#events.unshift(event);
        if (this.#event_loop)
            return;
        this.#event_loop = GLib.idle_add(GLib.PRIORITY_DEFAULT, () => {
            let event = this.#events.pop();
            if (event)
                system.run(event);
            if (this.#events.length === 0) {
                this.#event_loop = null;
                return false;
            }
            return true;
        });
    }
}
export class OnceExecutor {
    #iterable;
    #signal = null;
    constructor(iterable) {
        this.#iterable = iterable;
    }
    start(delay, apply, then) {
        this.stop();
        const iterator = this.#iterable[Symbol.iterator]();
        this.#signal = GLib.timeout_add(GLib.PRIORITY_DEFAULT, delay, () => {
            const next = iterator.next().value;
            if (typeof next === 'undefined') {
                if (then)
                    GLib.timeout_add(GLib.PRIORITY_DEFAULT, delay, () => {
                        then();
                        return false;
                    });
                return false;
            }
            return apply(next);
        });
    }
    stop() {
        if (this.#signal !== null)
            GLib.source_remove(this.#signal);
    }
}
export class ChannelExecutor {
    #channel = new Array();
    #signal = null;
    clear() {
        this.#channel.splice(0);
    }
    get length() {
        return this.#channel.length;
    }
    send(v) {
        this.#channel.push(v);
    }
    start(delay, apply) {
        this.stop();
        this.#signal = GLib.timeout_add(GLib.PRIORITY_DEFAULT, delay, () => {
            const e = this.#channel.shift();
            return typeof e === 'undefined' ? true : apply(e);
        });
    }
    stop() {
        if (this.#signal !== null)
            GLib.source_remove(this.#signal);
    }
}
