#!/usr/bin/gjs --module
import Adw from 'gi://Adw';
import Gio from 'gi://Gio';
import GioUnix from 'gi://GioUnix';
import GLib from 'gi://GLib';
import Gtk from 'gi://Gtk';
import Pango from 'gi://Pango';
const SCRIPT_DIR = GLib.path_get_dirname(new Error().stack.split(':')[0].slice(1));
imports.searchPath.push(SCRIPT_DIR);
import * as config from './config.js';
let app;
let instance = null;
const SYS_EXEMPTION_TITLE = 'System Exceptions';
const SYS_EXCEPTION_DESC = 'Updated based on validated user reports.';
const APPLICATION_ID = 'com.github.jardon.gnome-mosaic-exceptions';
var ViewNum;
(function (ViewNum) {
    ViewNum[ViewNum["MainView"] = 0] = "MainView";
    ViewNum[ViewNum["Exceptions"] = 1] = "Exceptions";
})(ViewNum || (ViewNum = {}));
export class MainView {
    constructor() {
        this.callback = () => { };
        let exceptions = this.exceptions_button();
        this.list = Gtk.ListBox.new();
        this.list.set_selection_mode(Gtk.SelectionMode.NONE);
        this.list.set_header_func(list_header_func);
        this.list.append(exceptions);
        let scroller = new Gtk.ScrolledWindow();
        scroller.hscrollbar_policy = Gtk.PolicyType.NEVER;
        scroller.set_propagate_natural_width(true);
        scroller.set_propagate_natural_height(true);
        scroller.set_child(this.list);
        let list_frame = Gtk.Frame.new(null);
        list_frame.set_child(scroller);
        let desc = new Gtk.Label({
            label: 'Add exceptions by selecting currently running applications and windows.',
            wrap: true,
        });
        desc.set_halign(Gtk.Align.CENTER);
        desc.set_justify(Gtk.Justification.CENTER);
        desc.set_max_width_chars(55);
        desc.set_margin_top(12);
        this.widget = Gtk.Box.new(Gtk.Orientation.VERTICAL, 24);
        this.widget.append(desc);
        this.widget.append(list_frame);
    }
    add_rule(wmclass, wmtitle) {
        let label = Gtk.Label.new(wmtitle === undefined ? wmclass : `${wmclass} / ${wmtitle}`);
        label.set_xalign(0);
        label.set_hexpand(true);
        label.set_ellipsize(Pango.EllipsizeMode.END);
        let button = Gtk.Button.new_from_icon_name('user-trash-symbolic');
        button.set_valign(Gtk.Align.CENTER);
        let widget = Gtk.Box.new(Gtk.Orientation.HORIZONTAL, 24);
        widget.append(label);
        widget.append(button);
        widget.set_margin_top(12);
        widget.set_margin_bottom(12);
        widget.set_margin_start(12);
        widget.set_margin_end(12);
        widget.set_margin_start(12);
        button.connect('clicked', () => {
            this.list.remove(widget);
            widget.set_visible(false);
            this.callback({ tag: 3, wmclass, wmtitle });
        });
        this.list.append(widget);
    }
    exceptions_button() {
        let label = Gtk.Label.new(SYS_EXEMPTION_TITLE);
        label.set_xalign(0);
        label.set_hexpand(true);
        label.set_ellipsize(Pango.EllipsizeMode.END);
        let description = Gtk.Label.new(SYS_EXCEPTION_DESC);
        description.set_xalign(0);
        description.get_style_context().add_class('dim-label');
        let button = Gtk.Button.new_from_icon_name('go-next-symbolic');
        button.set_valign(Gtk.Align.CENTER);
        let widget = Gtk.Box.new(Gtk.Orientation.HORIZONTAL, 24);
        widget.append(label);
        widget.append(description);
        widget.append(button);
        widget.set_margin_top(12);
        widget.set_margin_bottom(12);
        widget.set_margin_start(12);
        widget.set_margin_end(12);
        widget.set_margin_start(12);
        button.connect('clicked', () => this.callback({ tag: 1, view: ViewNum.Exceptions }));
        return widget;
    }
}
export class ExceptionsView {
    constructor() {
        this.callback = () => { };
        this.exceptions = Gtk.ListBox.new();
        let desc_title = Gtk.Label.new(`<b>${SYS_EXEMPTION_TITLE}</b>`);
        desc_title.set_use_markup(true);
        desc_title.set_xalign(0);
        let desc_desc = Gtk.Label.new(SYS_EXCEPTION_DESC);
        desc_desc.set_xalign(0);
        desc_desc.get_style_context().add_class('dim-label');
        desc_desc.set_margin_bottom(6);
        let scroller = new Gtk.ScrolledWindow();
        scroller.hscrollbar_policy = Gtk.PolicyType.NEVER;
        scroller.set_propagate_natural_width(true);
        scroller.set_propagate_natural_height(true);
        scroller.set_child(this.exceptions);
        let exceptions_frame = Gtk.Frame.new(null);
        exceptions_frame.set_child(scroller);
        this.exceptions.set_selection_mode(Gtk.SelectionMode.NONE);
        this.exceptions.set_header_func(list_header_func);
        this.widget = Gtk.Box.new(Gtk.Orientation.VERTICAL, 6);
        this.widget.append(desc_title);
        this.widget.append(desc_desc);
        this.widget.append(exceptions_frame);
    }
    add_rule(wmclass, wmtitle, enabled) {
        let label = Gtk.Label.new(wmtitle === undefined ? wmclass : `${wmclass} / ${wmtitle}`);
        label.set_xalign(0);
        label.set_hexpand(true);
        label.set_ellipsize(Pango.EllipsizeMode.END);
        let button = Gtk.Switch.new();
        button.set_valign(Gtk.Align.CENTER);
        button.set_state(enabled);
        button.set_active(true);
        button.connect('notify::state', () => {
            this.callback({
                tag: 2,
                wmclass,
                wmtitle,
                enable: button.get_state(),
            });
        });
        let widget = Gtk.Box.new(Gtk.Orientation.HORIZONTAL, 24);
        widget.append(label);
        widget.append(button);
        widget.set_margin_top(12);
        widget.set_margin_bottom(12);
        widget.set_margin_start(12);
        widget.set_margin_end(12);
        this.exceptions.append(widget);
    }
}
class App {
    constructor() {
        var _a, _b, _c, _d;
        this.main_view = new MainView();
        this.exceptions_view = new ExceptionsView();
        this.stack = Gtk.Stack.new();
        this.config = new config.Config();
        this.stack.set_margin_top(16);
        this.stack.set_margin_bottom(16);
        this.stack.set_margin_start(16);
        this.stack.set_margin_end(16);
        this.stack.add_child(this.main_view.widget);
        this.stack.add_child(this.exceptions_view.widget);
        let header = new Adw.HeaderBar();
        let add_exception = Gtk.Button.new_from_icon_name('list-add-symbolic');
        add_exception.set_valign(Gtk.Align.CENTER);
        add_exception.set_halign(Gtk.Align.START);
        let back = Gtk.Button.new_from_icon_name('go-previous-symbolic');
        back.set_valign(Gtk.Align.CENTER);
        back.set_halign(Gtk.Align.START);
        const TITLE = 'Floating Window Exceptions';
        let win = new Adw.Window();
        this.window = win;
        header.pack_start(add_exception);
        header.pack_start(back);
        win.set_deletable(true);
        win.set_title(TITLE);
        Adw.Window.set_default_icon_name('application-default');
        const vbox = new Gtk.Box({ orientation: Gtk.Orientation.VERTICAL });
        vbox.append(header);
        vbox.append(this.stack);
        win.default_width = 550;
        win.default_height = 700;
        win.set_content(vbox);
        back.hide();
        this.config.reload();
        for (const value of config.DEFAULT_FLOAT_RULES.values()) {
            let wmtitle = (_a = value.title) !== null && _a !== void 0 ? _a : undefined;
            let wmclass = (_b = value.class) !== null && _b !== void 0 ? _b : undefined;
            let disabled = this.config.rule_disabled({
                class: wmclass,
                title: wmtitle,
            });
            this.exceptions_view.add_rule(wmclass, wmtitle, !disabled);
        }
        for (const value of Array.from(this.config.float)) {
            let wmtitle = (_c = value.title) !== null && _c !== void 0 ? _c : undefined;
            let wmclass = (_d = value.class) !== null && _d !== void 0 ? _d : undefined;
            if (!value.disabled)
                this.main_view.add_rule(wmclass, wmtitle);
        }
        let event_handler = (event) => {
            switch (event.tag) {
                case 0:
                    println('SELECT');
                    app.quit();
                    break;
                case 1:
                    switch (event.view) {
                        case ViewNum.MainView:
                            this.stack.set_visible_child(this.main_view.widget);
                            back.hide();
                            add_exception.show();
                            break;
                        case ViewNum.Exceptions:
                            this.stack.set_visible_child(this.exceptions_view.widget);
                            back.show();
                            add_exception.hide();
                            break;
                    }
                    break;
                case 2:
                    log(`toggling exception ${event.enable}`);
                    this.config.toggle_system_exception(event.wmclass, event.wmtitle, !event.enable);
                    println('MODIFIED');
                    break;
                case 3:
                    log(`removing exception`);
                    this.config.remove_user_exception(event.wmclass, event.wmtitle);
                    println('MODIFIED');
                    break;
            }
        };
        this.main_view.callback = event_handler;
        this.exceptions_view.callback = event_handler;
        back.connect('clicked', () => event_handler({ tag: 1, view: ViewNum.MainView }));
        add_exception.connect('clicked', () => event_handler({ tag: 0 }));
    }
}
function list_header_func(row, before) {
    if (before) {
        row.set_header(Gtk.Separator.new(Gtk.Orientation.HORIZONTAL));
    }
}
const STDOUT = new Gio.DataOutputStream({
    base_stream: new GioUnix.OutputStream({ fd: 1 }),
});
function println(message) {
    STDOUT.put_string(message + '\n', null);
}
function main() {
    app = new Adw.Application({
        application_id: APPLICATION_ID,
        flags: Gio.ApplicationFlags.FLAGS_NONE,
    });
    app.connect('activate', () => {
        GLib.set_prgname(config.WM_CLASS_ID);
        GLib.set_application_name('GNOME Mosaic Floating Window Exceptions');
        if (instance !== null) {
            instance.window.present();
            return;
        }
        instance = new App();
        instance.window.set_application(app);
        instance.window.set_icon_name(APPLICATION_ID);
        instance.window.present();
    });
    app.connect('window-removed', () => {
        instance = null;
    });
    app.run([]);
}
main();
