// prefs.js — GNOME 46–48
import Adw from 'gi://Adw?version=1';
import Gtk from 'gi://Gtk?version=4.0';
import { ExtensionPreferences } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

export default class EversoloPrefs extends ExtensionPreferences {
  fillPreferencesWindow(window) {
    const settings = this.getSettings();

    const page  = new Adw.PreferencesPage({
      title: 'Eversolo Now Playing',
      icon_name: 'audio-x-generic-symbolic',
    });
    const group = new Adw.PreferencesGroup({ title: 'Conexión y servicios' });

    const rowBase = new Adw.ActionRow({
      title: 'Eversolo URL',
      subtitle: 'i.e : http://192.168.1.6:9529',
    });
    const entryBase = new Gtk.Entry({
      hexpand: true,
      text: settings.get_string('eversolo-base'),
    });
    entryBase.connect('changed', () =>
      settings.set_string('eversolo-base', entryBase.get_text().trim()),
    );
    rowBase.add_suffix(entryBase);
    rowBase.set_activatable_widget(entryBase);
    group.add(rowBase);

    const rowKey = new Adw.ActionRow({ title: 'Last.fm API key' });
    const entryKey = new Gtk.Entry({
      hexpand: true,
      text: settings.get_string('lastfm-apikey'),
      visibility: false,
    });
    entryKey.connect('changed', () =>
      settings.set_string('lastfm-apikey', entryKey.get_text().trim()),
    );
    rowKey.add_suffix(entryKey);
    rowKey.set_activatable_widget(entryKey);
    group.add(rowKey);

    const rowToggle = new Adw.ActionRow({ title: 'Show cover in tray bar' });
    const sw = new Gtk.Switch({
      valign: Gtk.Align.CENTER,
      active: settings.get_boolean('panel-cover'),
    });
    sw.connect('notify::active', () =>
      settings.set_boolean('panel-cover', sw.active),
    );
    rowToggle.add_suffix(sw);
    rowToggle.set_activatable_widget(sw);
    group.add(rowToggle);

    page.add(group);
    window.add(page);
  }
}

