import Clutter from 'gi://Clutter';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import { EdgeDragAction } from 'resource:///org/gnome/shell/ui/edgeDragAction.js';
import ExtensionFeature from '../../utils/extensionFeature.js';
import { GestureRecognizer, GestureRecognizerEvent } from '../../utils/ui/gestureRecognizer.js';
import St from 'gi://St';
import Shell from 'gi://Shell';

class PanelMenusSwipeToOpenFeature extends ExtensionFeature {
    constructor(pm) {
        super(pm);
        new GestureRecognizer({
            onGestureProgress: state => {
                if (currentMenu?.menu) {
                    currentMenu.menu.actor.translationY = -currentMenu.menu.get_transformed_size()[1] + state.totalMotionDelta.y;
                    currentMenu.menu.actor.show();
                }
            },
            onGestureCompleted: state => {
                if (currentMenu?.menu) {
                    if (state.lastMotionDirection?.direction === 'up') {
                        currentMenu.menu.actor.ease({
                            translationY: -currentMenu.menu.get_transformed_size()[1],
                            duration: 200,
                            onComplete: () => currentMenu.menu.actor.hide(),
                        });
                    }
                    else {
                        currentMenu.menu.actor.ease({
                            translationY: 0,
                            duration: 200,
                            //onComplete: () => currentMenu.menu.actor.hide(),
                        });
                    }
                }
            }
        });
        this.pm.patch(() => {
            const action = new EdgeDragAction(St.Side.TOP, Shell.ActionMode.ALL);
            action.connect('progress', (_, progress) => {
                const actor = Main.panel.statusArea.quickSettings.menu.actor;
                actor.show();
                actor.translationY = -actor.get_transformed_size()[1] + progress;
            });
            action.connect('activated', () => {
            });
            Main.panel.add_action_full('touchup-panel-menus-swipe-to-open', Clutter.EventPhase.CAPTURE, action);
            return () => Main.panel.remove_action(action);
        });
        this.pm.connectTo(Main.panel, 'captured-event', (_, evt) => {
            if (GestureRecognizerEvent.isTouch(evt)) ;
            return Clutter.EVENT_PROPAGATE;
        });
    }
}

export { PanelMenusSwipeToOpenFeature };
