// Wraps `gettext` to add support for template strings
export function templateTagWrapper(gettext) {
    return function (stringsArrayOrString, ...exprs) {
        const msgId = typeof stringsArrayOrString == "string"
            ? stringsArrayOrString
            : stringsArrayOrString
                .flatMap((str, i) => [str, i < exprs.length ? `{${i}}` : ""])
                .join("");
        let translated = gettext(msgId);
        for (let [i, expr] of exprs.entries()) {
            translated = translated.replace(`{${i}}`, `${expr}`);
        }
        return translated;
    };
}
