
export const YY = {
  cn: 0,
  hk: 1,
  tw: 2,
  auto: 3,
  p: 4,
  a: 5,
}
export const LANG = {
  jz: 2,
  fz: 1,
  en_p: 0,
  en_a: -1,
  de_p: -2,
  de_a: -3,
}
const tl = {}
// 繁體字
tl[LANG.fz] = {
  "农历": "農曆",
  "干支": "幹支",
  "节日": "節日",
  "%(SHI)时": "%(SHI)時",
}

// en
tl[LANG.en_p] = {
  "农历": "Lunar calendar",
  "节日": "Holidays",
  "干支": "Sexagenary cycle",
  "%(SHI)时": "%(SHI) H",
}
tl[LANG.en_a] = {
  ...tl[LANG.en_p],
  "%(SHI)时": "H.o.%(SHI)",
}

// de
tl[LANG.de_p] = {
  "农历": "Mondkalender",
  "节日": "Feste",
  "干支": "Stamm und Zweig",
  "%(SHI)时": "%(SHI).S",
}
tl[LANG.de_a] = {
  ...tl[LANG.de_p],
  "%(SHI)时": "S.d.%(SHI)",
}

export default function (lang, str) {
  if (lang in tl && str in tl[lang])
    return tl[lang][str]
  else
    return str
}
