import { isEmpty } from "./utils.js";
const TODOS = "todos";
export class TodoListManager {
    GSettings;
    constructor(extension) {
        this.GSettings = extension.getSettings();
    }
    get() {
        // retrieves todos as an array of strings
        return this.GSettings.get_strv(TODOS);
    }
    getTotalUndone() {
        // retrieves todos as an array of strings
        const todos = this.get();
        if (!todos.length) {
            return 0;
        }
        return todos.reduce((total, todo) => {
            const parsedTodo = JSON.parse(todo);
            return total + (!parsedTodo.isDone ? 1 : 0);
        }, 0);
    }
    add(task) {
        const todos = this.get();
        const newTask = JSON.stringify({ name: task, isDone: false });
        // Check if there's a focused task at index 0
        if (todos.length > 0) {
            const firstTask = JSON.parse(todos[0]);
            if (firstTask.isFocused) {
                // Insert at position 1 (after the focused task)
                todos.splice(1, 0, newTask);
            }
            else {
                // Insert at position 0 (at the top)
                todos.unshift(newTask);
            }
        }
        else {
            // If no tasks exist, just add it
            todos.push(newTask);
        }
        this.GSettings.set_strv(TODOS, todos);
    }
    remove(index) {
        const todos = this.get();
        if (isEmpty(todos)) {
            return;
        }
        todos.splice(index, 1);
        this.GSettings.set_strv(TODOS, todos);
    }
    update(index, todo) {
        const todos = this.get();
        if (isEmpty(todos)) {
            return;
        }
        if (todo.isFocused && index > 0) {
            // focus should only be on a single field
            // i don't want to update all the other ones isFocused to false
            // it's just not good, to know if it's focus just check if index === 0 and isFocused = true
            // we will move it to the top
            const tmp = todos[0];
            todos[0] = JSON.stringify(todo, null, 2);
            todos[index] = tmp;
        }
        else {
            todos[index] = JSON.stringify(todo, null, 2);
        }
        this.GSettings.set_strv(TODOS, todos);
    }
}
