# 📌 Top Panel Logo – Customizable Click Actions for GNOME Shell

Top Panel Logo is a lightweight GNOME Shell extension that adds a customizable icon to the GNOME top panel.

Both left‑click and right‑click actions are user‑configurable, allowing for powerful shortcuts without cluttering your workflow.

## ✨ What it does

Places a customizable icon/logo in the GNOME Shell top panel (left section).

Left click and right click can be assigned to different actions from a fixed set of useful options.

Designed to be lightweight: no background polling, no unnecessary signals — all actions run instantly on click.

## 🛠 Available Actions

For either Left Click or Right Click (independently), choose from:

Show Overview – Opens/closes GNOME Activities Overview.

Show Apps Menu – Opens GNOME’s applications grid view.

Hide All Windows (Toggle Minimize/Restore Windows On Current Workspace) – Behavior matches GNOME's “Hide all normal windows” / Super+D shortcut.

Open System Monitor – Launches gnome-system-monitor if installed.

Launch App – Launch a user‑chosen application (.desktop app or command).

Custom Command – Run any shell command you define.

Do Nothing - Does nothing.

## 🎨 Icon Customization

Icon Path – Point to any PNG, JPEG, or SVG file to display.

Icon Size – Set the pixel size of your panel icon.

Horizontal Padding – Adjust space on either side of the icon.

## 🚀 Usage Examples

Left click: Show Overview, Right click: Hide All Windows.

Left click: Launch Terminal, Right click: Open System Monitor.

Left click: Custom Command (toggle VPN), Right click: Show Apps Menu.

## 📋 Requirements

GNOME Shell 48+

gnome-system-monitor if you want to use the Open System Monitor action.

For Custom Command or Launch App, use valid executable commands.

## 📦 Installation

From GNOME Extensions website – search for “Top Panel Logo”.

From GitHub – clone this repo to ~/.local/share/gnome-shell/extensions/top-panel-logo@jmpegi.github.com and restart GNOME Shell.

## 📝 License

Released under GPL‑3.0 — feel free to modify or contribute.

Copyright (C) 2025 jmpegi <jmpegi@protonmail.com>


Any feedback, ideas and bug reports are welcome!