import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';

import WindowTricks from './windowtricks.js'
import Settings from './helpers/settings.js';

export default class GtileExtension extends Extension {
    _tricks;

    enable() {
        Settings.initialize(this.getSettings());
        this._tricks = new WindowTricks();
    }

    disable() {
        Settings.destroy();
        this._tricks?.destroy();
        this._tricks = null;
    }
}
