import GObject from 'gi://GObject';
import Direction from '../enums/direction.js';
import Settings from '../helpers/settings.js';
import * as windowHelper from '../helpers/window.js'

export default GObject.registerClass(
    class Focuser extends GObject.Object {
        _keybind;

        constructor(keybind) {
            super()

            this._keybind = keybind;
            this._keybind.registerKeybind(Settings.KEY_FOCUS_RIGHT, this.focusRight.bind(this));
            this._keybind.registerKeybind(Settings.KEY_FOCUS_LEFT, this.focusLeft.bind(this));
            this._keybind.registerKeybind(Settings.KEY_FOCUS_UP, this.focusUp.bind(this));
            this._keybind.registerKeybind(Settings.KEY_FOCUS_DOWN, this.focusDown.bind(this));
        }

        focusRight() {
            this._focus(Direction.Right);
        }

        focusLeft() {
            this._focus(Direction.Left);
        }

        focusUp() {
            this._focus(Direction.Up);
        }

        focusDown() {
            this._focus(Direction.Down);
        }

        _focus(direction) {
            let window = windowHelper.getFocusedWindow();
            if (!window) {
                return;
            }

            let windows = windowHelper.getNearbyWindows(window, direction, false);
            if (window.length === 0) {
                return;
            }

            windowHelper.focusWindow(windows[0]);
        }

        destroy() {
            this._keybind.removeKeybinding(Settings.KEY_FOCUS_RIGHT);
            this._keybind.removeKeybinding(Settings.KEY_FOCUS_LEFT);
            this._keybind.removeKeybinding(Settings.KEY_FOCUS_UP);
            this._keybind.removeKeybinding(Settings.KEY_FOCUS_DOWN);
        }
    }
);