import GObject from 'gi://GObject';
import Settings from '../helpers/settings.js';
import * as windowHelper from '../helpers/window.js';
import * as screenHelper from '../helpers/screen.js';

export default GObject.registerClass(
    class Resizer extends GObject.Object {
        _keybind;

        constructor(keybind) {
            super();

            this._keybind = keybind;
            this._keybind.registerKeybind(Settings.KEY_GROW_X, this.growX.bind(this));
            this._keybind.registerKeybind(Settings.KEY_GROW_Y, this.growY.bind(this));
            this._keybind.registerKeybind(Settings.KEY_SHRINK_X, this.shrinkX.bind(this));
            this._keybind.registerKeybind(Settings.KEY_SHRINK_Y, this.shrinkY.bind(this));
        }

        shrinkX() {
            this._resize(false, false);
        }

        shrinkY() {
            this._resize(false, true);
        }

        growX() {
            this._resize(true, false);
        }

        growY() {
            this._resize(true, true);
        }

        _resize(grow, vertical) {
            let window = windowHelper.getFocusedWindow();
            if (!window) {
                return;
            }

            let workspace = window.workspace;
            let windowSize = window.size;
            let screenSize = screenHelper.getScreenSize(workspace);

            let amount = Settings.getResizeAmount() * 10 * (grow ? 1 : -1);

            if (vertical) {
                windowSize.height += amount;
            } else {
                windowSize.width += amount;
            }

            let windowWidth = windowSize.x + windowSize.width;
            let screenWidth = screenSize.x + screenSize.width;

            let windowHeight = windowSize.y + windowSize.height;
            let screenHeight = screenSize.y + screenSize.height;

            if (windowWidth > screenWidth) {
                windowSize.width -= windowWidth - screenWidth;
            }

            if (windowHeight > screenHeight) {
                windowSize.height -= windowHeight - screenHeight;
            }

            windowHelper.resizeWindow(window, windowSize);
        }

        destroy() {
            this._keybind.removeKeybinding(Settings.KEY_GROW_X);
            this._keybind.removeKeybinding(Settings.KEY_GROW_Y);
            this._keybind.removeKeybinding(Settings.KEY_SHRINK_X);
            this._keybind.removeKeybinding(Settings.KEY_SHRINK_Y);
        }
    }
);
