import GObject from 'gi://GObject';
import KeybindManager from './keybind.js';
import Centerer from './tricks/centerer.js'
import Switcher from './tricks/switcher.js'
import Resizer from './tricks/resizer.js';
import Mover from './tricks/mover.js';
import Focuser from './tricks/focuser.js'
import Snapper from './tricks/snapper.js';

export default GObject.registerClass(
    class WindowTricks extends GObject.Object {
        _keybind;

        _centerer;
        _resizer;
        _focuser;
        _switcher;
        _mover;
        _snapper;

        constructor() {
            super()

            this._keybind = new KeybindManager();

            this._centerer = new Centerer(this._keybind);
            this._resizer = new Resizer(this._keybind);
            this._switcher = new Switcher(this._keybind);
            this._focuser = new Focuser(this._keybind);
            this._mover = new Mover(this._keybind);
            this._snapper = new Snapper(this._keybind);            
        }

        destroy() {
            this._keybind.destroy();

            this._centerer.destroy();
            this._resizer.destroy();
            this._switcher.destroy();
            this._focuser.destroy();
            this._snapper.destroy();
            this._mover.destroy();
        }
    }
);