// src/utils/logger.ts
var PROJECT_NAME = "Vicinae";
var LogLevel = /* @__PURE__ */ ((LogLevel2) => {
  LogLevel2[LogLevel2["ERROR"] = 0] = "ERROR";
  LogLevel2[LogLevel2["WARN"] = 1] = "WARN";
  LogLevel2[LogLevel2["INFO"] = 2] = "INFO";
  LogLevel2[LogLevel2["DEBUG"] = 3] = "DEBUG";
  return LogLevel2;
})(LogLevel || {});
var currentLogLevel = 2 /* INFO */;
var log = (level, message, data) => {
  if (level > currentLogLevel) {
    return;
  }
  const timestamp = (/* @__PURE__ */ new Date()).toISOString();
  const levelName = LogLevel[level];
  const prefix = `[${PROJECT_NAME}] ${timestamp} ${levelName}`;
  if (data) {
    console.log(`${prefix}: ${message}`);
    if (typeof data === "object" && data !== null) {
      Object.entries(data).forEach(([key, value]) => {
        console.log(`${prefix}:   ${key}: ${value}`);
      });
    } else {
      console.log(`${prefix}: ${data}`);
    }
  } else {
    console.log(`${prefix}: ${message}`);
  }
};
var info = (message, data) => {
  log(2 /* INFO */, message, data);
};
var error = (message, error2) => {
  const timestamp = (/* @__PURE__ */ new Date()).toISOString();
  const prefix = `[${PROJECT_NAME}] ${timestamp} ERROR`;
  if (error2) {
    console.error(`${prefix}: ${message}`);
    console.error(`${prefix}: ${String(error2)}`);
  } else {
    console.error(`${prefix}: ${message}`);
  }
};

// src/core/launcher/focus-tracker.ts
var FocusTracker = class {
  constructor(onFocusChange) {
    this.onFocusChange = onFocusChange;
  }
  focusHandler;
  enable() {
    try {
      this.focusHandler = global.display.connect(
        "notify::focus-window",
        (_display, _window) => {
          this.onFocusChange();
        }
      );
      info("FocusTracker: Focus tracking enabled");
    } catch (error2) {
      error("FocusTracker: Error enabling focus tracking", error2);
      throw error2;
    }
  }
  disable() {
    if (this.focusHandler) {
      global.display.disconnect(this.focusHandler);
      this.focusHandler = void 0;
    }
    info("FocusTracker: Focus tracking disabled");
  }
};
export {
  FocusTracker
};
