// src/utils/logger.ts
var PROJECT_NAME = "Vicinae";
var LogLevel = /* @__PURE__ */ ((LogLevel2) => {
  LogLevel2[LogLevel2["ERROR"] = 0] = "ERROR";
  LogLevel2[LogLevel2["WARN"] = 1] = "WARN";
  LogLevel2[LogLevel2["INFO"] = 2] = "INFO";
  LogLevel2[LogLevel2["DEBUG"] = 3] = "DEBUG";
  return LogLevel2;
})(LogLevel || {});
var stringToLogLevel = (level) => {
  switch (level.toLowerCase()) {
    case "error":
      return 0 /* ERROR */;
    case "warn":
      return 1 /* WARN */;
    case "info":
      return 2 /* INFO */;
    case "debug":
      return 3 /* DEBUG */;
    default:
      return 2 /* INFO */;
  }
};
var _globalSettings = null;
var currentLogLevel = 2 /* INFO */;
var initializeLogger = (settings) => {
  _globalSettings = settings;
  const levelString = settings.get_string("logging-level");
  currentLogLevel = stringToLogLevel(levelString);
  settings.connect("changed::logging-level", () => {
    const newLevelString = settings.get_string("logging-level");
    currentLogLevel = stringToLogLevel(newLevelString);
    log(2 /* INFO */, `Log level changed to: ${newLevelString}`);
  });
  log(2 /* INFO */, `Logger initialized with level: ${levelString}`);
};
var log = (level, message, data) => {
  if (level > currentLogLevel) {
    return;
  }
  const timestamp = (/* @__PURE__ */ new Date()).toISOString();
  const levelName = LogLevel[level];
  const prefix = `[${PROJECT_NAME}] ${timestamp} ${levelName}`;
  if (data) {
    console.log(`${prefix}: ${message}`);
    if (typeof data === "object" && data !== null) {
      Object.entries(data).forEach(([key, value]) => {
        console.log(`${prefix}:   ${key}: ${value}`);
      });
    } else {
      console.log(`${prefix}: ${data}`);
    }
  } else {
    console.log(`${prefix}: ${message}`);
  }
};
var debug = (message, data) => {
  log(3 /* DEBUG */, message, data);
};
var info = (message, data) => {
  log(2 /* INFO */, message, data);
};
var warn = (message, data) => {
  log(1 /* WARN */, message, data);
};
var error = (message, error2) => {
  const timestamp = (/* @__PURE__ */ new Date()).toISOString();
  const prefix = `[${PROJECT_NAME}] ${timestamp} ERROR`;
  if (error2) {
    console.error(`${prefix}: ${message}`);
    console.error(`${prefix}: ${String(error2)}`);
  } else {
    console.error(`${prefix}: ${message}`);
  }
};
export {
  LogLevel,
  debug,
  error,
  info,
  initializeLogger,
  warn
};
