import * as Ecs from './ecs.js';
export var NodeKind;
(function (NodeKind) {
    NodeKind[NodeKind["FORK"] = 1] = "FORK";
    NodeKind[NodeKind["WINDOW"] = 2] = "WINDOW";
})(NodeKind || (NodeKind = {}));
function node_variant_as_string(value) {
    return value == NodeKind.FORK ? 'NodeVariant::Fork' : 'NodeVariant::Window';
}
export class Node {
    inner;
    constructor(inner) {
        this.inner = inner;
    }
    toJSON() {
        return {
            inner: this.inner,
        };
    }
    static fromJSON(data) {
        return new Node(data.inner);
    }
    static fork(entity) {
        return new Node({ kind: NodeKind.FORK, entity });
    }
    static window(entity) {
        return new Node({ kind: NodeKind.WINDOW, entity });
    }
    display(fmt) {
        fmt += `{\n    kind: ${node_variant_as_string(this.inner.kind)},\n    `;
        switch (this.inner.kind) {
            case 1:
            case 2:
                fmt += `entity: (${this.inner.entity})\n  }`;
                return fmt;
        }
    }
    is_fork(entity) {
        return (this.inner.kind === 1 && Ecs.entity_eq(this.inner.entity, entity));
    }
    is_window(entity) {
        return (this.inner.kind === 2 && Ecs.entity_eq(this.inner.entity, entity));
    }
    measure(tiler, ext, parent, area, record) {
        switch (this.inner.kind) {
            case 1:
                const fork = tiler.forks.get(this.inner.entity);
                if (fork) {
                    record;
                    fork.measure(tiler, ext, area, record);
                }
                break;
            case 2:
                record(this.inner.entity, parent, area.clone());
                break;
        }
    }
}
