export var Movement;
(function (Movement) {
    Movement[Movement["NONE"] = 0] = "NONE";
    Movement[Movement["MOVED"] = 1] = "MOVED";
    Movement[Movement["GROW"] = 2] = "GROW";
    Movement[Movement["SHRINK"] = 4] = "SHRINK";
    Movement[Movement["LEFT"] = 8] = "LEFT";
    Movement[Movement["UP"] = 16] = "UP";
    Movement[Movement["RIGHT"] = 32] = "RIGHT";
    Movement[Movement["DOWN"] = 64] = "DOWN";
})(Movement || (Movement = {}));
export function calculate(from, change) {
    const xchange = change.x - from.x;
    const ychange = change.y - from.y;
    const wchange = change.width - from.width;
    const hchange = change.height - from.height;
    const result = [];
    if (xchange === 0 && ychange === 0 && wchange === 0 && hchange === 0) {
        return [Movement.NONE];
    }
    if (wchange !== 0) {
        if (wchange > 0) {
            result.push(Movement.GROW | (xchange < 0 ? Movement.LEFT : Movement.RIGHT));
        }
        else {
            result.push(Movement.SHRINK | (xchange > 0 ? Movement.RIGHT : Movement.LEFT));
        }
    }
    if (hchange !== 0) {
        if (hchange > 0) {
            result.push(Movement.GROW | (ychange < 0 ? Movement.UP : Movement.DOWN));
        }
        else {
            result.push(Movement.SHRINK | (ychange > 0 ? Movement.DOWN : Movement.UP));
        }
    }
    if (result.length === 0 && (xchange !== 0 || ychange !== 0)) {
        result.push(Movement.MOVED);
    }
    return result;
}
