import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';

import WindowTricks from './windowtricks.js'
import Keybinds from './helpers/keybinds.js';
import Settings from './helpers/settings.js';

export default class GtileExtension extends Extension {
    _tricks;
    _keybinds;

    enable() {
        Settings.initialize(this.getSettings());

        this._keybinds = new Keybinds();        
        this._tricks = new WindowTricks(this._keybinds);
    }

    disable() {
        Settings.destroy();

        this._keybinds?.distroy();
        this._keybinds = null;

        this._tricks?.destroy();
        this._tricks = null;
    }
}
