import GObject from 'gi://GObject';
import Direction from '../enums/direction.js';
import Settings from '../helpers/settings.js';
import * as windowHelper from '../helpers/window.js'

export default GObject.registerClass(
    class Focuser extends GObject.Object {
        _keybinds;

        constructor(keybinds) {
            super()

            this._keybinds = keybinds;
            this._keybinds.registerKeybind(Settings.KEY_FOCUS_RIGHT, this.focusRight.bind(this));
            this._keybinds.registerKeybind(Settings.KEY_FOCUS_LEFT, this.focusLeft.bind(this));
            this._keybinds.registerKeybind(Settings.KEY_FOCUS_UP, this.focusUp.bind(this));
            this._keybinds.registerKeybind(Settings.KEY_FOCUS_DOWN, this.focusDown.bind(this));
        }

        focusRight() {
            this._focus(Direction.Right);
        }

        focusLeft() {
            this._focus(Direction.Left);
        }

        focusUp() {
            this._focus(Direction.Up);
        }

        focusDown() {
            this._focus(Direction.Down);
        }

        _focus(direction) {
            let window = windowHelper.getFocusedWindow();
            if (!window) {
                return;
            }

            let windows = windowHelper.getNearbyWindows(window, direction, false);
            if (window.length === 0) {
                return;
            }

            windowHelper.focusWindow(windows[0]);
        }

        destroy() {
            this._keybinds.removeKeybinding(Settings.KEY_FOCUS_RIGHT);
            this._keybinds.removeKeybinding(Settings.KEY_FOCUS_LEFT);
            this._keybinds.removeKeybinding(Settings.KEY_FOCUS_UP);
            this._keybinds.removeKeybinding(Settings.KEY_FOCUS_DOWN);

            this._keybinds = null;
        }
    }
);