export default class Settings {
    static _settings;

    static MAXIMIZE_MODE = 'maximize-mode';
    static ULTRA_WIDE_MODE = 'ultra-wide-mode';
    static ORIGINAL_SIZE_MODE = "original-size-mode";
    static WINDOW_ADJUST_AMOUNT = 'window-adjust-amount';
    static CLIPBOARD_STATE = 'clipboard-state';
    static APP_TRAY_STATE = 'app-tray-state';
    static CLIPBOARD_MAX = 'clipboard-history-max';
    static APP_TRAY_ICON_SIZE = 'app-tray-icon-size';

    static KEY_CLIPBOARD = "clipboard-hotkey";
    static KEY_CENTER_WINDOW = "center-window-hotkey";
    static KEY_CENTER_WINDOWS = "center-windows-hotkey";
    static KEY_CENTER_WORKSPACE = "center-workspace-hotkey";
    static KEY_SWITCH_RIGHT = "switch-right-hotkey";
    static KEY_SWITCH_LEFT = "switch-left-hotkey";
    static KEY_SWITCH_UP = "switch-up-hotkey";
    static KEY_SWITCH_DOWN = "switch-down-hotkey";
    static KEY_SNAP_RIGHT = "snap-right-hotkey";
    static KEY_SNAP_LEFT = "snap-left-hotkey";
    static KEY_SNAP_UP = "snap-up-hotkey";
    static KEY_SNAP_DOWN = "snap-down-hotkey";
    static KEY_MOVE_RIGHT = "move-right-hotkey";
    static KEY_MOVE_LEFT = "move-left-hotkey";
    static KEY_MOVE_UP = "move-up-hotkey";
    static KEY_MOVE_DOWN = "move-down-hotkey";
    static KEY_SHRINK_X = "shrink-x-hotkey";
    static KEY_SHRINK_Y = "shrink-y-hotkey";
    static KEY_GROW_X = "grow-x-hotkey";
    static KEY_GROW_Y = "grow-y-hotkey";
    static KEY_FOCUS_RIGHT = "focus-right-hotkey";
    static KEY_FOCUS_LEFT = "focus-left-hotkey";
    static KEY_FOCUS_UP = "focus-up-hotkey";
    static KEY_FOCUS_DOWN = "focus-down-hotkey";

    static get reference() {
        return this._settings;
    }

    static initialize(settings) {
        this._settings = settings;
    }

    static resetKeyBinds() {
        for (let key of Object.keys(this)) {
            if (key.startsWith("KEY_")) {
                this._settings.reset(this[key]);
            }
        }
    }

    static tryGetBoolean(key){
        if (!this._settings)
            return null;

        try{
            return this._settings.get_boolean(key);
        }catch{
            return null;
        }
    }

    static tryGetInteger(key){
         if (!this._settings)
            return null;

        try{
            return this._settings.get_uint(key);
        }catch{
            return null;
        }
    }

    static getKeyBind(key) {
        return (this._settings?.get_strv(key)[0] ?? '');
    }

    static setKeyBind(key, keybind) {
        return (this._settings?.set_strv(key, [keybind]) ?? false);
    }

    static bind(key, object, property, flags) {
        this._settings?.bind(key, object, property, flags);
    }

    static destroy() {
        this._settings = null;
    }

}