import St from 'gi://St';
import Shell from 'gi://Shell';
import GObject from 'gi://GObject';
import Settings from '../helpers/settings.js';
import * as Main from "resource:///org/gnome/shell/ui/main.js"
import * as PanelMenu from 'resource:///org/gnome/shell/ui/panelMenu.js';

export default GObject.registerClass(
    class AppTray extends GObject.Object {
        _keybinds;
        _tracker;

        _tray;
        _desktopSignal;
        _workspaceSignal;
        _windowLeftSignal;
        _windowFocusSignal;
        _windowEnteredSignal;
        _windowCreatedSignal;
        _windowAttentionSignal;

        constructor(keybinds) {
            super();

            this._keybinds = keybinds;

            this._workspaceSingals = [];
            this._tray = new St.BoxLayout();
            this._tracker = Shell.WindowTracker.get_default();

            this._windowLeftSignal = global.display.connect('window-left-monitor', this._render.bind(this));
            this._windowFocusSignal = global.display.connect('notify::focus-window', this._render.bind(this));
            this._windowEnteredSignal = global.display.connect('window-entered-monitor', this._render.bind(this));
            this._windowCreatedSignal = global.display.connect('window-created', this._render.bind(this));
            this._windowAttentionSignal = global.display.connect('window-demands-attention', this._render.bind(this));
            this._desktopSignal = global.workspace_manager.connect("showing-desktop-changed", this._render.bind(this));
            this._workspaceSignal = global.workspace_manager.connect("active-workspace-changed", this._render.bind(this));

            Main.panel._leftBox.add_child(this._tray);
        }

        _render() {
            this._tray.destroy_all_children()

            let layout = new St.BoxLayout();
            let menu = new PanelMenu.Button();
            menu.add_child(layout)

            let apps = []

            let workspaceId = global.workspace_manager.get_active_workspace_index();
            this._addAppIcon(workspaceId, layout, apps, 255);

            let workspaceCount = global.workspace_manager.get_n_workspaces();
            for (let id = 0; id < workspaceCount; id++) {
                this._addAppIcon(id, layout, apps, 100);
            }

            this._tray.add_child(menu.container);
        }

        _addAppIcon(workspaceId, layout, apps, opacity) {
            let workspace = global.workspace_manager.get_workspace_by_index(workspaceId)
            let windows = workspace.list_windows();

            for (let window of windows) {
                let app = this._tracker.get_window_app(window);
                if (!app || apps.includes(app)) {
                    continue;
                }

                apps.push(app);

                let size = this._getAppIconSize();
                let icon = app.create_icon_texture(size);

                icon.set_style_class_name(`bar-app-icon`)
                icon.set_opacity(opacity)

                layout.add_child(icon);
            }
        }


        _getAppIconSize() {
            return Settings.tryGetInteger(Settings.APP_TRAY_ICON_SIZE) ?? 20;
        }

        destroy() {
            Main.panel._leftBox.remove_child(this._tray);

            this._tray.destroy_all_children()

            global.display.disconnect(this._desktopSignal);
            global.display.disconnect(this._workspaceSignal);
            global.display.disconnect(this._windowLeftSignal);
            global.display.disconnect(this._windowFocusSignal);
            global.display.disconnect(this._windowEnteredSignal);
            global.display.disconnect(this._windowCreatedSignal);
            global.display.disconnect(this._windowAttentionSignal);

            this._tray = null;
            this._tracker = null;
            this._keybinds = null;
            this._desktopSignal = null;
            this._workspaceSignal = null;
            this._windowLeftSignal = null;
            this._windowFocusSignal = null;
            this._windowEnteredSignal = null;
            this._windowCreatedSignal = null;
            this._windowAttentionSignal = null;
        }
    }
);
