import GObject from 'gi://GObject';
import AppTray from './tricks/apptray.js';
import Centerer from './tricks/centerer.js'
import Clipboard from './tricks/clipboard.js'
import Focuser from './tricks/focuser.js'
import Mover from './tricks/mover.js';
import Resizer from './tricks/resizer.js';
import Snapper from './tricks/snapper.js';
import Switcher from './tricks/switcher.js'
import Settings from './helpers/settings.js';

export default GObject.registerClass(
    class WindowTricks extends GObject.Object {
        _keybinds;

        _app;
        _centerer;
        _clipboard;
        _focuser;
        _mover;
        _resizer;
        _snapper;
        _switcher;

        constructor(keybinds) {
            super()

            this._keybinds = keybinds;

            this._centerer = new Centerer(this._keybinds);
            this._focuser = new Focuser(this._keybinds);
            this._mover = new Mover(this._keybinds);
            this._resizer = new Resizer(this._keybinds);
            this._snapper = new Snapper(this._keybinds);
            this._switcher = new Switcher(this._keybinds);

            if(this._getShowClipboard()){
                this._clipboard = new Clipboard(this._keybinds);
            }
            
            if(this._getShowAppTray()){
                this._app = new AppTray(this._keybinds);
            }
        }

        _getShowClipboard() {
            return Settings.tryGetBoolean(Settings.CLIPBOARD_STATE) ?? true;
        }

        _getShowAppTray() {
            return Settings.tryGetBoolean(Settings.APP_TRAY_STATE) ?? true;
        }

        destroy() {
            this._keybinds = null;

            this._app?.destroy();
            this._centerer?.destroy();
            this._clipboard?.destroy();
            this._focuser?.destroy();
            this._mover?.destroy();
            this._resizer?.destroy();
            this._snapper?.destroy();
            this._switcher?.destroy();
        }
    }
);