import { PopupMenu } from "resource:///org/gnome/shell/ui/popupMenu.js";
import FullscreenBoxpointer from "./boxpointer.js";
import PanelGrid from "./grid.js";
// The spacing between panels in the grid, in pixels.
const GRID_SPACING = 5;
export default class PanelGridMenu extends PopupMenu {
    // @ts-expect-error: replacing some gnome types
    box;
    constructor(source, arrow_alignment, arrow_side, monitor, default_panel, settings) {
        super(source, arrow_alignment, arrow_side);
        const new_boxpointer = new FullscreenBoxpointer(arrow_side);
        // Replace the box
        this.box = new PanelGrid(new_boxpointer, monitor, default_panel, settings);
        this.box.style = `spacing-rows: ${GRID_SPACING}px; spacing-columns: ${GRID_SPACING}px`;
        // Delete some things
        global.focus_manager.remove_group(this.actor);
        this._boxPointer.destroy();
        // Code from PopupMenu's constructor
        this._boxPointer = new_boxpointer;
        this.actor = this._boxPointer;
        // @ts-expect-error: `_delegate` is never defined anywhere
        this.actor._delegate = this;
        this.actor.style_class = "popup-menu-boxpointer";
        this._boxPointer.bin.set_child(this.box);
        this.actor.add_style_class_name("popup-menu");
        global.focus_manager.add_group(this.actor);
        this.actor.reactive = true;
    }
    get transparent() {
        return this._boxPointer.transparent && this.box.transparent;
    }
    set transparent(value) {
        this._boxPointer.transparent = value;
    }
    get panels() {
        // just assume that we have only valid panels
        return this.box.get_children();
    }
    close(animate) {
        for (const panel of this.panels) {
            panel.close?.(animate);
        }
        super.close(animate);
    }
    add_panel(panel) {
        this.box.add_child(panel);
    }
}
