// Copyright Sebastian Wiesner <sebastian@swsnr.de>
//
// Licensed under the EUPL
//
// See https://interoperable-europe.ec.europa.eu/collection/eupl/eupl-text-eupl-12
import GObject from "gi://GObject";
/**
 * A class to control offline updates.
 */
export const OfflineUpdateController = GObject.registerClass({
    Properties: {
        "offline-update-backend": GObject.ParamSpec.jsobject("backend", null, null, GObject.ParamFlags.READWRITE),
    },
}, class OfflineUpdateController extends GObject.Object {
    _backend = null;
    _log;
    constructor(log) {
        super();
        this._log = log;
    }
    get backend() {
        return this._backend;
    }
    set backend(backend) {
        this._backend = backend;
    }
    /**
     * Cancel a pending update.
     *
     * @returns `true` if the update was cancelled, `false` otherwise
     */
    async cancelPendingUpdate() {
        if (this._backend) {
            this._log.log("Cancelling pending offline update");
            await this._backend.cancel();
            return true;
        }
        else {
            this._log.log("No backend for offline update");
            return false;
        }
    }
    /**
     * Get all packages that will be updated.
     *
     * @returns A list of packages, or `null` if there's no pending update.
     */
    async getPackagesToUpdate() {
        if (this._backend) {
            return this._backend.packages();
        }
        else {
            return Promise.resolve(null);
        }
    }
});
