import Gio from 'gi://Gio';
import { wm } from 'resource:///org/gnome/shell/ui/main.js';

class InterfaceSettings {
  #settings;
  #originalShouldAnimate;
  #timeout;

  constructor() {
    this.#settings = new Gio.Settings({ schema_id: 'org.gnome.desktop.interface' });
    this.#originalShouldAnimate = wm._shouldAnimate;
  }

  /**
   * From https://extensions.gnome.org/extension/119/disable-window-animations/
   */
  maybeSuppressAnimation(shouldSuppress, callback) {
    const windowManager = wm;

    if (
      shouldSuppress &&
      typeof windowManager._shouldAnimate === 'function' &&
      this.#settings.get_boolean('enable-animations')
    ) {
      this.maybeClearTimeout();
      windowManager._shouldAnimate = () => false;
      callback();

      this.#timeout = setTimeout(() => {
        windowManager._shouldAnimate = this.#originalShouldAnimate;
      }, 100);
    } else {
      callback();
    }
  }

  maybeClearTimeout() {
    if (this.#timeout) {
      clearTimeout(this.#timeout);
    }
  }

  dispose() {
    this.maybeClearTimeout();
    wm._shouldAnimate = this.#originalShouldAnimate;
  }
}

export { InterfaceSettings as default };
