const appInfoToAppConfig = ({ appId, appInfo, hotkey }) => {
  return {
    id: appInfo?.get_id() ?? appId,
    name: appInfo?.get_name() ?? appId,
    description: appInfo?.get_description() ?? '',
    icon: appInfo?.get_icon()?.to_string() ?? 'application-x-executable',
    hotkey: hotkey ?? '',
  };
};

const findWindowByAppConfig = (windowTracker, appConfig) => {
  for (const windowActor of global.get_window_actors()) {
    const window = windowActor.get_meta_window();

    if (!window || window.is_override_redirect()) {
      continue;
    }

    if (isAppMatch(windowTracker.get_window_app(window), appConfig)) {
      return window;
    }
  }

  return void 0;
};

const getFocusedWindowByApp = (app) => {
  return app ? app.get_windows().find((window) => window.has_focus()) : void 0;
};

const isAppMatch = (app, appConfig) => {
  return app ? app.get_name() === appConfig.name : false;
};

export { appInfoToAppConfig, findWindowByAppConfig, getFocusedWindowByApp, isAppMatch };
