import {Extension} from 'resource:///org/gnome/shell/extensions/extension.js';
import * as ExtensionTheme from './theme.js';
import {TileWindowManager} from './tileWindowManager.js';
import KeybindingHandler from './settingsHandlers/keybindingHandler.js';
import SwitchHandler from './settingsHandlers/switchHandler.js';
import SpinHandler from './settingsHandlers/spinHandler.js';
import {Tile} from './tile.js';
import {loadExecutables} from './autocomplete.js';
export default class Grimble extends Extension {
    _tileWindowManager;
    _settings = null;
    _keybindingHandler;
    _switchHandler;
    _spinHandler;
    enable() {
        this._settings = this.getSettings();
        ExtensionTheme.enableWindowTheme();
        Tile.padding = this._settings.get_int('tile-padding');
        this._tileWindowManager = new TileWindowManager();
        this._keybindingHandler = new KeybindingHandler(this._tileWindowManager, this._settings);
        this._switchHandler = new SwitchHandler(this._tileWindowManager, this._settings);
        this._spinHandler = new SpinHandler(this._tileWindowManager, this._settings);
        loadExecutables();
    }

    disable() {
        this._tileWindowManager?._saveBeforeSessionLock();
        // Restore theme
        ExtensionTheme.disableWindowTheme();
        this._tileWindowManager?.destroy();
        this._tileWindowManager = undefined;
        this._keybindingHandler?.destroy();
        this._keybindingHandler = undefined;
    }
}
