import {Orientation} from './tile.js';
export class Position {
    proportion;
    x;
    y;
    width;
    height;
    index;
    splitProportion;
    constructor(proportion = 1.0, x = 0, y = 0, width = 0, height = 0, index = 0) {
        this.proportion = proportion;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.index = index;
        this.splitProportion = 0.5;
    }

    split(orientation = null) {
        let vertical;
        let newPosition1 = new Position();
        newPosition1.proportion = this.proportion * this.splitProportion;
        newPosition1.x = this.x;
        newPosition1.y = this.y;
        newPosition1.index = 0;
        switch (orientation) {
        case null:
        case Orientation.None:
            if (this.width > this.height) {
                vertical = true;
                newPosition1.width = this.width * this.splitProportion;
                newPosition1.height = this.height;
            } else {
                vertical = false;
                newPosition1.width = this.width;
                newPosition1.height = this.height * this.splitProportion;
            }
            break;
        case Orientation.Horizontal:
            vertical = true;
            newPosition1.width = this.width * this.splitProportion;
            newPosition1.height = this.height;
            break;
        case Orientation.Vertical:
            vertical = false;
            newPosition1.width = this.width;
            newPosition1.height = this.height * this.splitProportion;
            break;
        }
        let newPosition2 = new Position(this.proportion * (1 - this.splitProportion), vertical ? this.x + this.width * this.splitProportion : this.x, vertical ? this.y : this.y + this.height * this.splitProportion, vertical ? this.width * (1 - this.splitProportion) : this.width, vertical ? this.height : this.height * (1 - this.splitProportion), 1);
        return [newPosition1, newPosition2];
    }

    static fromObject(obj) {
        let pos = new Position(obj.proportion, obj.x, obj.y, obj.width, obj.height, obj.index);
        pos.splitProportion = obj.splitProportion;
        return pos;
    }
}
