import Gio from 'gi://Gio';
import Gtk from 'gi://Gtk';
import './prefs/shortcutListener.js';
import {Shortcut, Switches, Radio, Spin} from './prefs/settings.js';
import {ExtensionPreferences} from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';
export default class GrimblePreferences extends ExtensionPreferences {
    _settings = null;
    _prefWindow = null;
    fillPreferencesWindow(window) {
        const settings = this.getSettings();
        const builder = Gtk.Builder.new_from_file(`${this.path}/ui/prefs.ui`);
        const page1 = this.createGeneralSettingsPage(builder, settings);
        const page2 = this.createKeybindingsPage(builder, settings);
        window.add(page1);
        window.add(page2);
        return Promise.resolve();
    }

    createGeneralSettingsPage(builder, settings) {
        const page1 = builder.get_object('general');
        this._bindRadioButtons(builder, settings);
        this._bindSwitches(builder, settings);
        this._bindSpinbuttons(builder, settings);
        return page1;
    }

    createKeybindingsPage(builder, settings) {
        const page2 = builder.get_object('keybindings');
        let keys = Shortcut.getShortcuts();
        keys.forEach(key => {
            const shortcut = builder.get_object(key.replaceAll('-', '_'));
            shortcut.initialize(key, settings);
        });
        return page2;
    }

    _bindRadioButtons(builder, settings) {
        const radioButtons = Radio.getRadios();
        radioButtons.forEach(({key, rowNames}) => {
            const currActive = settings.get_int(key);
            rowNames.forEach((name, idx) => {
                const row = builder.get_object(name.replaceAll('-', '_'));
                const checkButton = row.activatable_widget;
                checkButton.connect('toggled', () => {
                    settings.set_int(key, idx);
                });
                // Set initial state
                if (idx === currActive)
                    checkButton.activate();
            });
        });
    }

    _bindSwitches(builder, settings) {
        const switches = Switches.getSwitches();
        switches.forEach(key => {
            const widget = builder.get_object(key.replaceAll('-', '_'));
            settings.bind(key, widget, 'active', Gio.SettingsBindFlags.DEFAULT);
        });
    }

    _bindSpinbuttons(builder, settings) {
        const spinButtons = Spin.getSpins();
        spinButtons.forEach(key => {
            const widget = builder.get_object(key.replaceAll('-', '_'));
            settings.bind(key, widget, 'value', Gio.SettingsBindFlags.DEFAULT);
        });
    }
}
