import {Spin} from '../prefs/settings.js';
import {Extension} from 'resource:///org/gnome/shell/extensions/extension.js';
import {Tile} from '../tile.js';
export default class SpinHandler {
    _spins;
    _windowManager;
    constructor(windowManager, settings) {
        this._windowManager = windowManager;
        this._spins = Spin.getSpins();
        this._spins.forEach(key => {
            settings.connect(`changed::${key}`, () => this._onSwitchChanged(key, settings));
        });
    }

    _onSwitchChanged(key, settings) {
        let extensionObject;
        let metadata;
        switch (key) {
        case 'tile-padding':
            extensionObject = Extension.lookupByUUID('grimble@lmt.github.io');
            metadata = extensionObject?.metadata;
            if (metadata && settings.get_int('tile-padding')) {
                Tile.padding = settings.get_int('tile-padding');
                this._windowManager.updateMonitors();
            }
            break;
        default:
            break;
        }
    }
}
