import '../node_modules/@girs/gnome-shell/dist/ui/slider.js';
import '../node_modules/@girs/gnome-shell/dist/ui/panelMenu.js';
import '../node_modules/@girs/gnome-shell/dist/ui/popupMenu.js';
import Gio from 'gi://Gio';
import Player from './Player.js';
import St from 'gi://St';
import GObject from 'gi://GObject';
import { ICONS, SETTINGS_KEYS } from '../utils/constants.js';
import { isCurrentRadioPlaying } from '../utils/helpers.js';
import { debug } from '../utils/debug.js';
import { Button } from 'resource:///org/gnome/shell/ui/panelMenu.js';
import { PopupSeparatorMenuItem, PopupBaseMenuItem, PopupMenuSection, PopupImageMenuItem } from 'resource:///org/gnome/shell/ui/popupMenu.js';
import { Slider } from 'resource:///org/gnome/shell/ui/slider.js';

class Indicator extends Button {
    static {
        GObject.registerClass(this);
    }
    mpvPlayer;
    _activeRadioPopupItem = null;
    _radios;
    _icon;
    _extension;
    _isUpdatingCurrentRadio = false;
    signalsHandlers = [];
    menuSignals = [];
    constructor(ext) {
        super(0.0, 'Quick Lofi');
        this._extension = ext;
        this.mpvPlayer = new Player(this._extension._settings);
        this.mpvPlayer.initVolumeControl();
        this._icon = new St.Icon({
            gicon: Gio.icon_new_for_string(this._extension.path + ICONS.INDICATOR_DEFAULT),
            iconSize: 20,
            styleClass: 'system-status-icon indicator-icon',
        });
        this.add_child(this._icon);
        this._createMenu();
        this._bindSettingsChangeEvents();
        this._handleButtonClick();
    }
    _createRadios() {
        const radios = this._extension._settings.get_strv(SETTINGS_KEYS.RADIOS_LIST);
        this._radios = radios.map((entry) => {
            const parts = entry.split(' - ');
            const radioName = (parts[0] || '').trim();
            const radioUrl = (parts[1] || '').trim();
            const id = (parts[2] || '').trim();
            return { radioName, radioUrl, id };
        });
    }
    _handlePopupMaxHeight() {
        const isPopupMaxHeightSet = this._extension._settings.get_boolean(SETTINGS_KEYS.SET_POPUP_MAX_HEIGHT);
        const popupMaxHeight = this._extension._settings.get_string(SETTINGS_KEYS.POPUP_MAX_HEIGHT);
        const styleString = isPopupMaxHeightSet ? popupMaxHeight : 'auto';
        this.menu.box.style = `
        max-height: ${styleString};
      `;
    }
    _bindSettingsChangeEvents() {
        this.signalsHandlers.push({
            emitter: this._extension._settings,
            signalID: this._extension._settings.connect('changed', (_, key) => {
                if (key === SETTINGS_KEYS.RADIOS_LIST) {
                    if (this.mpvPlayer.isPlaying()) {
                        const currentRadioPlayingID = this._extension._settings.get_string(SETTINGS_KEYS.CURRENT_RADIO_PLAYING);
                        const currentRadioPlaying = this._radios.find((radio) => radio.id === currentRadioPlayingID);
                        const [updatedRadioName, updatedRadioUrl, id] = this._extension._settings
                            .get_strv(SETTINGS_KEYS.RADIOS_LIST)
                            .find((radio) => radio.endsWith(currentRadioPlayingID))
                            .split(' - ');
                        if (currentRadioPlaying.radioUrl !== updatedRadioUrl.trim() && currentRadioPlaying.id === id) {
                            const isPaused = this.mpvPlayer.getProperty('pause').data;
                            if (!isPaused) {
                                this._isUpdatingCurrentRadio = true;
                                this.mpvPlayer.startPlayer({ id, radioName: updatedRadioName, radioUrl: updatedRadioUrl });
                                this._updateIndicatorIcon({ playing: 'playing' });
                                this._activeRadioPopupItem.setIcon(Gio.icon_new_for_string(ICONS.POPUP_STOP));
                                this._activeRadioPopupItem.set_style('font-weight: bold');
                            }
                            else if (isPaused) {
                                this.mpvPlayer.stopPlayer();
                                this.mpvPlayer.startPlayer({ id, radioName: updatedRadioName, radioUrl: updatedRadioUrl });
                                this.mpvPlayer.playPause();
                            }
                            return;
                        }
                    }
                    if (!this._isUpdatingCurrentRadio) {
                        this._createMenu();
                    }
                }
            }),
        });
        this.signalsHandlers.push({
            emitter: this._extension._settings,
            signalID: this._extension._settings.connect(`changed::${SETTINGS_KEYS.CURRENT_RADIO_PLAYING}`, () => {
                if (this.mpvPlayer.isPlaying() &&
                    this._extension._settings.get_string(SETTINGS_KEYS.CURRENT_RADIO_PLAYING).length <= 0) {
                    this.mpvPlayer.stopPlayer();
                }
            }),
        });
        this.signalsHandlers.push({
            emitter: this._extension._settings,
            signalID: this._extension._settings.connect(`changed::${SETTINGS_KEYS.SET_POPUP_MAX_HEIGHT}`, () => {
                this._handlePopupMaxHeight();
            }),
        });
        this.signalsHandlers.push({
            emitter: this._extension._settings,
            signalID: this._extension._settings.connect(`changed::${SETTINGS_KEYS.POPUP_MAX_HEIGHT}`, () => {
                this._handlePopupMaxHeight();
            }),
        });
        this.signalsHandlers.push({
            emitter: this.mpvPlayer,
            signalID: this.mpvPlayer.connect('play-state-changed', (sender, isPaused) => {
                this._activeRadioPopupItem.setIcon(Gio.icon_new_for_string(isPaused ? ICONS.POPUP_PAUSE : ICONS.POPUP_STOP));
                this._updateIndicatorIcon({ playing: isPaused ? 'paused' : 'playing' });
            }),
        });
        this.signalsHandlers.push({
            emitter: this.mpvPlayer,
            signalID: this.mpvPlayer.connect('playback-stopped', () => {
                if (this._isUpdatingCurrentRadio) {
                    this._isUpdatingCurrentRadio = false;
                    this._createMenu();
                    return;
                }
                this._updateIndicatorIcon({ playing: 'default' });
                this._activeRadioPopupItem.setIcon(Gio.icon_new_for_string(ICONS.POPUP_PLAY));
                this._extension._settings.set_string(SETTINGS_KEYS.CURRENT_RADIO_PLAYING, '');
                this._activeRadioPopupItem.set_style('font-weight: normal');
                this._activeRadioPopupItem = null;
            }),
        });
    }
    _updateIndicatorIcon({ playing }) {
        const extPath = this._extension.path;
        const icon = `INDICATOR_${playing.toUpperCase()}`;
        const iconPath = `${extPath}/${ICONS[icon]}`;
        const gicon = Gio.icon_new_for_string(iconPath);
        this._icon.set_gicon(gicon);
    }
    _togglePlayingStatus(child, radioID, mouseButton) {
        const isRightClickOnActiveRadio = child === this._activeRadioPopupItem && mouseButton === 3;
        const isLeftClickOnActiveRadio = child === this._activeRadioPopupItem && mouseButton === 1;
        if (isRightClickOnActiveRadio) {
            this.mpvPlayer.stopPlayer();
            return;
        }
        if (isLeftClickOnActiveRadio) {
            this.mpvPlayer.playPause();
            return;
        }
        const currentRadio = this._radios.find((radio) => radio.id === radioID);
        if (this._activeRadioPopupItem) {
            this._activeRadioPopupItem.setIcon(Gio.icon_new_for_string(ICONS.POPUP_PLAY));
            this._activeRadioPopupItem.set_style('font-weight: normal');
            this._updateIndicatorIcon({ playing: 'default' });
        }
        this.mpvPlayer.startPlayer(currentRadio);
        this._updateIndicatorIcon({ playing: 'playing' });
        child.setIcon(Gio.icon_new_for_string(ICONS.POPUP_STOP));
        child.set_style('font-weight: bold');
        this._extension._settings.set_string(SETTINGS_KEYS.CURRENT_RADIO_PLAYING, radioID);
        this._activeRadioPopupItem = child;
    }
    _handleButtonClick() {
        this.connect('button-press-event', (_, event) => {
            const RIGHT_CLICK = 3;
            if (event.get_button() === RIGHT_CLICK) {
                this.menu.close(false);
                this._extension.openPreferences();
                return;
            }
        });
    }
    _createMenu() {
        this._activeRadioPopupItem = null;
        this.menuSignals.forEach(({ emitter, signalID }) => {
            try {
                emitter.disconnect(signalID);
            }
            catch (e) { }
        });
        this.menuSignals = [];
        this.menu.box.destroy_all_children();
        this._radios = [];
        this._createRadios();
        this._createMenuItems();
    }
    _createVolumeSlider(popup) {
        const separator = new PopupSeparatorMenuItem();
        const volumeLevel = this._extension._settings.get_int(SETTINGS_KEYS.VOLUME);
        const volumePopupItem = new PopupBaseMenuItem({ reactive: false });
        const volumeBoxLayout = new St.BoxLayout({ vertical: true, x_expand: true });
        const volumeSlider = new Slider(volumeLevel / 100);
        this.menuSignals.push({
            emitter: volumeSlider,
            signalID: volumeSlider.connect('notify::value', (slider) => {
                const currentVolume = (slider.value * 100).toFixed(0);
                volumeLabel.text = `Volume: ${currentVolume}`;
                this._extension._settings.set_int(SETTINGS_KEYS.VOLUME, Number(currentVolume));
            }),
        });
        this.signalsHandlers.push({
            emitter: this._extension._settings,
            signalID: this._extension._settings.connect(`changed::${SETTINGS_KEYS.VOLUME}`, (settings, key) => {
                const volume = settings.get_int(key);
                volumeLabel.text = `Volume: ${volume}`;
                volumeSlider.value = volume / 100;
            }),
        });
        const volumeLabel = new St.Label({ text: `Volume: ${volumeSlider.value * 100}` });
        volumeBoxLayout.add_child(volumeLabel);
        volumeBoxLayout.add_child(volumeSlider);
        volumePopupItem.add_child(volumeBoxLayout);
        popup.addMenuItem(separator);
        popup.addMenuItem(volumePopupItem);
    }
    _createMenuItems() {
        const scrollView = new St.ScrollView();
        const popupSection = new PopupMenuSection();
        scrollView.add_child(popupSection.actor);
        const isPaused = this.mpvPlayer.getProperty('pause') ?? { data: false };
        this._radios.forEach((radio) => {
            const isRadioPlaying = isCurrentRadioPlaying(this._extension._settings, radio.id);
            const menuItem = new PopupImageMenuItem(radio.radioName, Gio.icon_new_for_string(isRadioPlaying && isPaused.data ? ICONS.POPUP_PAUSE : isRadioPlaying ? ICONS.POPUP_STOP : ICONS.POPUP_PLAY));
            if (isRadioPlaying) {
                menuItem.set_style('font-weight: bold');
                this._activeRadioPopupItem = menuItem;
            }
            this.menuSignals.push({
                emitter: menuItem,
                signalID: menuItem.connect('activate', (item, event) => {
                    const mouseButton = event.get_button();
                    this._togglePlayingStatus(item, radio.id, mouseButton);
                }),
            });
            popupSection.addMenuItem(menuItem);
        });
        this._createVolumeSlider(popupSection);
        this.menu.box.add_child(scrollView);
        this._handlePopupMaxHeight();
    }
    dispose() {
        debug('extension disabled');
        this._extension._settings.set_string(SETTINGS_KEYS.CURRENT_RADIO_PLAYING, '');
        this.mpvPlayer.stopPlayer();
        this.signalsHandlers.forEach(({ emitter, signalID }) => {
            emitter.disconnect(signalID);
        });
        this.menuSignals.forEach(({ emitter, signalID }) => {
            try {
                emitter.disconnect(signalID);
            }
            catch (e) { }
        });
        this.signalsHandlers = [];
        this.menuSignals = [];
        this.destroy();
    }
}

export { Indicator as default };
