import '../node_modules/@girs/gnome-shell/dist/ui/main.js';
import Meta from 'gi://Meta';
import Shell from 'gi://Shell';
import { SHORTCUTS } from '../utils/constants.js';
import { wm } from 'resource:///org/gnome/shell/ui/main.js';

class ShortcutsHandler {
    _settings;
    _player;
    constructor(_settings, _player) {
        this._settings = _settings;
        this._player = _player;
        this.handleShortcuts();
    }
    handleShortcuts() {
        wm.addKeybinding(SHORTCUTS.PLAY_PAUSE_SHORTCUT, this._settings, Meta.KeyBindingFlags.IGNORE_AUTOREPEAT, Shell.ActionMode.NORMAL, () => {
            this._player.playPause();
        });
        wm.addKeybinding(SHORTCUTS.STOP_SHORTCUT, this._settings, Meta.KeyBindingFlags.IGNORE_AUTOREPEAT, Shell.ActionMode.NORMAL, () => {
            this._player.stopPlayer();
        });
    }
    _removeShortcuts() {
        Object.values(SHORTCUTS).forEach((key) => {
            wm.removeKeybinding(key);
        });
    }
    destroy() {
        this._removeShortcuts();
    }
}

export { ShortcutsHandler as default };
