import Adw from "gi://Adw";
import Gio from "gi://Gio";

import {
  ExtensionPreferences,
  gettext as _,
} from "resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js";

export default class RepeatToCyclePreferences extends ExtensionPreferences {
  fillPreferencesWindow(window) {
    const settings = this.getSettings();

    const page = new Adw.PreferencesPage();
    const group = new Adw.PreferencesGroup();
    page.add(group);

    const row = new Adw.SwitchRow({
      title: _("Current workspace only"),
      subtitle: _("Cycle apps from the current workspace only"),
    });

    settings.bind(
      "current-workspace-only",
      row,
      "active",
      Gio.SettingsBindFlags.DEFAULT,
    );
    group.add(row);
    window.add(page);
  }
}
