/**
 * SPDX-FileCopyrightText: 2024 Wesley Benica <wesley@benica.dev>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
export function createDateConstants(fns) {
    const { _, pgettext } = fns;
    const dateOnly = () => pgettext('This is how someone would say the day of the month only. As in, "My rent is due on the %s."', "the %s");
    const weekdays = () => [
        pgettext('The day of the week and the date. The date will be substituted in the %s. For example, "Sunday the fifth".', "sunday the %s"),
        pgettext('The day of the week and the date. The date will be substituted in the %s. For example, "Monday the sixth".', "monday the %s"),
        pgettext('The day of the week and the date. The date will be substituted in the %s. For example, "Tuesday the seventh".', "tuesday the %s"),
        pgettext('The day of the week and the date. The date will be substituted in the %s. For example, "Wednesday the eighth".', "wednesday the %s"),
        pgettext('The day of the week and the date. The date will be substituted in the %s. For example, "Thursday the ninth".', "thursday the %s"),
        pgettext('The day of the week and the date. The date will be substituted in the %s. For example, "Friday the tenth".', "friday the %s"),
        pgettext('The day of the week and the date. The date will be substituted in the %s. For example, "Saturday the eleventh".', "saturday the %s"),
    ];
    // Plain weekday names for standalone weekday display (Sunday..Saturday)
    const weekdayNames = () => [
        pgettext("Short standalone weekday name", "sunday"),
        pgettext("Short standalone weekday name", "monday"),
        pgettext("Short standalone weekday name", "tuesday"),
        pgettext("Short standalone weekday name", "wednesday"),
        pgettext("Short standalone weekday name", "thursday"),
        pgettext("Short standalone weekday name", "friday"),
        pgettext("Short standalone weekday name", "saturday"),
    ];
    const daysOfMonth = () => [
        _("first"),
        _("second"),
        _("third"),
        _("fourth"),
        _("fifth"),
        _("sixth"),
        _("seventh"),
        _("eighth"),
        _("ninth"),
        _("tenth"),
        _("eleventh"),
        _("twelfth"),
        _("thirteenth"),
        _("fourteenth"),
        _("fifteenth"),
        _("sixteenth"),
        _("seventeenth"),
        _("eighteenth"),
        _("nineteenth"),
        _("twentieth"),
        _("twenty first"),
        _("twenty second"),
        _("twenty third"),
        _("twenty fourth"),
        _("twenty fifth"),
        _("twenty sixth"),
        _("twenty seventh"),
        _("twenty eighth"),
        _("twenty ninth"),
        _("thirtieth"),
        _("thirty first"),
    ];
    return {
        dateOnly,
        weekdays,
        weekdayNames,
        daysOfMonth,
    };
}
