/*
 * SPDX-FileCopyrightText: 2024 Wesley Benica <wesley@benica.dev>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
/**
 * Extension context gettext utilities.
 *
 * This module provides gettext functions for the extension context.
 * It attempts to use the real GNOME Shell gettext functions when available,
 * and falls back to test-friendly functions during testing/compilation.
 */
// Default fallback functions for testing
let _fn = (s) => s;
let _n = (s, p, n) => (n === 1 ? s : p);
let _p = (_ctx, s) => s;
/**
 * Initialize gettext functions with runtime dependencies.
 * This should be called by the extension during initialization.
 */
export function initExtensionGettext(gettext, ngettext, pgettext) {
    _fn = gettext;
    _n = ngettext;
    _p = pgettext;
}
/**
 * Gettext functions for extension context (main extension code).
 * Uses injected functions when available, falls back to test functions.
 */
export const extensionGettext = {
    _: (msgid) => _fn(msgid),
    ngettext: (msgid, msgid_plural, n) => _n(msgid, msgid_plural, n),
    pgettext: (msgctxt, msgid) => _p(msgctxt, msgid),
};
