/* Quick Settings Touchpad Toggle GNOME Shell Extension
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

import Gio from 'gi://Gio';
import GObject from 'gi://GObject';

import { Extension, gettext as _ } from 'resource:///org/gnome/shell/extensions/extension.js';

import * as Config from 'resource:///org/gnome/shell/misc/config.js';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import * as PopupMenu from 'resource:///org/gnome/shell/ui/popupMenu.js';
import * as QuickSettings from 'resource:///org/gnome/shell/ui/quickSettings.js';
const QuickSettingsMenu = Main.panel.statusArea.quickSettings;
const ShellVersion = parseFloat(Config.PACKAGE_VERSION);

const TouchpadToggle = GObject.registerClass(
	class TouchpadToggle extends QuickSettings.QuickToggle {
		_init(extensionObject) {
			super._init({
				title: _('Touchpad'),
				toggleMode: true,
			});

			this._settings = new Gio.Settings({
				schema_id: 'org.gnome.desktop.peripherals.touchpad',
			});
			this._changedId = this._settings.connect('changed::send-events',
				() => this._sync());

			this.connectObject(
				'clicked', () => this._toggleMode(),
				this);
			this._sync();
		}

		_toggleMode() {
			this._settings.set_enum('send-events',
				this.checked ? 0 : 1);
		}

		_sync() {
			const touchpadSendEvents = this._settings.get_enum('send-events');
			const checked = touchpadSendEvents === 0
			if (this.checked !== checked)
				this.set({checked});
			this.iconName = checked
				? ('input-touchpad-symbolic')
				: ('touchpad-disabled-symbolic');
		}

		destroy() {
			this._settings.disconnect(this._changedId);
			super.destroy();
		}
	});

const TouchpadIndicator = GObject.registerClass(
	class TouchpadIndicator extends QuickSettings.SystemIndicator {
		_init(extensionObject) {
			super._init();
			this.quickSettingsItems.push(new TouchpadToggle(this));
		}

		destroy(extensionObject) {
			this.quickSettingsItems.forEach(item => item.destroy());
			super.destroy();
		}
	});

export default class TouchpadExtension extends Extension {
	enable() {
		this._indicator = new TouchpadIndicator(this);
		Main.panel.statusArea.quickSettings.addExternalIndicator(this._indicator);
	}

	disable() {
		this._indicator.destroy(this);
		this._indicator = null;
	}
}
