import GLib from 'gi://GLib';
import {TileWindowManager} from './tileWindowManager.js';
export var resizeSourceId = null;
/** Resize Tile with size of rect in the East
 *
 * @param {Tile} tile
 * @param {Mtk.Rectangle} rect
 * @returns
 */
export function resizeE(tile, rect) {
    if (!tile.adjacents[1]) {
        if (resizeSourceId !== null)
            GLib.Source.remove(resizeSourceId);
        resizeSourceId = GLib.idle_add(GLib.PRIORITY_DEFAULT, () => {
            TileWindowManager.getMonitors()[tile.monitor].root?.update();
            resizeSourceId = null;
            return GLib.SOURCE_REMOVE;
        });
        return;
    }
    let p = tile.findParent(el => el.position.x + el.position.width === tile.position.x + tile.position.width);
    if (p) {
        let pos = p.position;
        let diff = rect.width - tile.position.width;
        pos.width += diff;
        p.resize(pos);
        p.update();
        let sibling = p.getSibling();
        if (sibling) {
            let posSib = sibling.position;
            posSib.width -= diff;
            posSib.x += diff;
            sibling.resize(posSib);
            sibling.update();
        }
        if (p.parent && p.parent.child2)
            p.parent.position.splitProportion = 0.5 * (p.parent.position.width - p.parent.child2.position.width) / p.parent.child2.position.width;
    }
}
/** Resize Tile with size of rect in the West
 *
 * @param {Tile} tile
 * @param {Mtk.Rectangle} rect
 * @returns
 */
export function resizeW(tile, rect) {
    if (!tile.adjacents[0]) {
        if (resizeSourceId !== null)
            GLib.Source.remove(resizeSourceId);
        resizeSourceId = GLib.idle_add(GLib.PRIORITY_DEFAULT, () => {
            TileWindowManager.getMonitors()[tile.monitor].root?.update();
            resizeSourceId = null;
            return GLib.SOURCE_REMOVE;
        });
        return;
    }
    let p = tile.findParent(el => el.position.x === tile.position.x);
    if (p) {
        let pos = p.position;
        let diff = rect.width - tile.position.width;
        pos.width += diff;
        pos.x -= diff;
        p.resize(pos);
        p.update();
        let sibling = p.getSibling();
        if (sibling) {
            let posSib = sibling.position;
            posSib.width -= diff;
            sibling.resize(posSib);
            sibling.update();
        }
        if (p.parent && p.parent.child2)
            p.parent.position.splitProportion = 0.5 * (p.parent.position.width - p.parent.child2.position.width) / p.parent.child2.position.width;
    }
}
/** Resize Tile with size of rect in the South
 *
 * @param {Tile} tile
 * @param {Mtk.Rectangle} rect
 * @returns
 */
export function resizeS(tile, rect) {
    if (!tile.adjacents[3]) {
        if (resizeSourceId !== null)
            GLib.Source.remove(resizeSourceId);
        resizeSourceId = GLib.idle_add(GLib.PRIORITY_DEFAULT, () => {
            TileWindowManager.getMonitors()[tile.monitor].root?.update();
            resizeSourceId = null;
            return GLib.SOURCE_REMOVE;
        });
        return;
    }
    let p = tile.findParent(el => el.position.y + el.position.height === tile.position.y + tile.position.height);
    if (p) {
        let pos = p.position;
        let diff = rect.height - pos.height;
        pos.height = rect.height;
        p.resize(pos);
        p.update();
        let sibling = p.getSibling();
        if (sibling) {
            let posSib = sibling.position;
            posSib.height -= diff;
            posSib.y += diff;
            sibling.resize(posSib);
            sibling.update();
        }
        if (p.parent && p.parent.child2)
            p.parent.position.splitProportion = 0.5 * (p.parent.position.height - p.parent.child2.position.height) / p.parent.child2.position.height;
    }
}
/** Resize Tile with size of rect in the North
 *
 * @param {Tile} tile
 * @param {Mtk.Rectangle} rect
 * @returns
 */
export function resizeN(tile, rect) {
    if (!tile.adjacents[2]) {
        if (resizeSourceId !== null)
            GLib.Source.remove(resizeSourceId);
        resizeSourceId = GLib.idle_add(GLib.PRIORITY_DEFAULT, () => {
            TileWindowManager.getMonitors()[tile.monitor].root?.update();
            resizeSourceId = null;
            return GLib.SOURCE_REMOVE;
        });
        return;
    }
    let p = tile.findParent(el => el.position.y === tile.position.y);
    if (p) {
        let pos = p.position;
        let diff = rect.height - pos.height;
        pos.height += diff;
        pos.y -= diff;
        p.resize(pos);
        p.update();
        let sibling = p.getSibling();
        if (sibling) {
            let posSib = sibling.position;
            posSib.height -= diff;
            sibling.resize(posSib);
            sibling.update();
        }
        if (p.parent && p.parent.child2)
            p.parent.position.splitProportion = 0.5 * (p.parent.position.height - p.parent.child2.position.height) / p.parent.child2.position.height;
    }
}
