import {Spin} from '../common.js';
import {Tile} from '../tile.js';
export default class SpinHandler {
    _spins;
    _windowManager;
    constructor(windowManager, extension) {
        this._windowManager = windowManager;
        this._spins = Spin.getSpins();
        this._spins.forEach(key => {
            extension.getSettings().connect(`changed::${key}`, () => this._onSwitchChanged(key, extension));
        });
    }

    _onSwitchChanged(key, extension) {
        let extensionObject;
        let metadata;
        switch (key) {
        case 'tile-padding':
            extensionObject = extension;
            metadata = extensionObject?.metadata;
            if (metadata && extension.getSettings().get_int('tile-padding')) {
                Tile.padding = extension.getSettings().get_int('tile-padding');
                this._windowManager.updateMonitors();
            }
            break;
        default:
            break;
        }
    }
}
