import {Switches} from '../common.js';
import {enableWindowTheme} from '../theme.js';
export default class SwitchHandler {
    _switchs;
    _windowManager;
    constructor(windowManager, extension) {
        this._windowManager = windowManager;
        this._switchs = Switches.getSwitches();
        this._switchs.forEach(key => {
            extension.getSettings().connect(`changed::${key}`, () => this._onSwitchChanged(key, extension));
        });
    }

    _onSwitchChanged(key, extension) {
        switch (key) {
        case 'header-bar':
            if (extension.metadata && extension.getSettings().get_boolean('header-bar'))
                enableWindowTheme();

            else if (extension.metadata)
                enableWindowTheme();

            break;
        default:
            break;
        }
    }
}
