import Gio from 'gi://Gio';
import Pango from 'gi://Pango';

import {Extension} from 'resource:///org/gnome/shell/extensions/extension.js';

import * as IBusManager from 'resource:///org/gnome/shell/misc/ibusManager.js';

export default class WindowListExtension extends Extension {
    constructor(metadata) {
        super(metadata);
    }

    _updateFont() {
	// We restore the default font style.
	this._candidatePopup.style = '';

	let useCustomFont = this._ibusSettings.get_boolean('use-custom-font');
	if (!useCustomFont)
            return;

	let fontName = this._ibusSettings.get_string('custom-font');
	let fontDesc = Pango.FontDescription.from_string(fontName);

	// We ignore everything but size and style.
	this._candidatePopup.style =
            'font-size: ' + fontDesc.get_size() / 1024. + (fontDesc.get_size_is_absolute() ? 'px' : 'pt') + ';'
            + 'font-family: "' + fontDesc.get_family() + '";';
    }

    enable() {
    	this._ibusManager = IBusManager.getIBusManager();
	this._candidatePopup = this._ibusManager._candidatePopup;

	this._ibusSettings = new Gio.Settings({ schema_id: 'org.freedesktop.ibus.panel' });

	this._useCustomFontId = this._ibusSettings.connect
		('changed::use-custom-font', this._updateFont.bind(this));
	this._customFontId = this._ibusSettings.connect
		('changed::custom-font', this._updateFont.bind(this));

	this._updateFont();
    }

    disable() {
	this._ibusSettings.disconnect(this._useCustomFontId);
	this._useCustomFontId = null;

	this._ibusSettings.disconnect(this._customFontId);
	this._customFontId = null;

	this._ibusSettings = null;

	this._candidatePopup.style = '';
	this._candidatePopup = null;
	
	this._ibusManager = null;
    }
}
