/* -*- mode: js2; js2-basic-offset: 4; indent-tabs-mode: nil -*- */

import Gio from 'gi://Gio';
import GLib from 'gi://GLib';
import Gtk from 'gi://Gtk?version=4.0';
import GObject from 'gi://GObject';

import Adw from 'gi://Adw';

import {ExtensionPreferences, gettext as _} from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

class IBusSettingsWidget extends Gtk.Box {
    static {
        GObject.registerClass(this);
    }

    constructor() {
        super({orientation: Gtk.Orientation.HORIZONTAL,
                     spacing: 6,
                     margin_top: 36,
                     margin_bottom: 36,
                     margin_start: 36,
                     margin_end: 36,
                     halign: Gtk.Align.FILL,
                     valign: Gtk.Align.START,
                    });

        this._settings = new Gio.Settings({ schema_id: 'org.freedesktop.ibus.panel' });

        let fontLabel = '<b>' + _("IBus Candidates Font") + '</b>';
        this.append(new Gtk.Label({ label: fontLabel, use_markup: true,
                                    halign: Gtk.Align.START,}));

        let fontButton = new Gtk.FontButton({halign: Gtk.Align.END,});
        let fontName = "Sans 10";

        let useCustomFont = this._settings.get_boolean('use-custom-font');

        if (useCustomFont) {
            fontName = this._settings.get_string('custom-font');
        }

        fontButton.font = fontName;

        fontButton.connect('font-set', (widget) => {
            fontName = widget.font;
            this._settings.set_boolean('use-custom-font', true);
            this._settings.set_string('custom-font', fontName);
        });
        
        this.append(fontButton);
    }
}

export default class IBusSettingsPrefs extends ExtensionPreferences {
    fillPreferencesWindow(window) {
        let page = new Adw.PreferencesPage();
        page.set_title(_('IBus Font Settings'));
        let group = new Adw.PreferencesGroup();
        group.set_title(_('IBus Font Settings'));
        group.add(new IBusSettingsWidget());
        page.add(group);
        window.add(page);
    }
}
