import GLib from 'gi://GLib';
import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import Utils from './src/utils.js';
import VueMeterSystemContainer from './src/container.js';
export default class VueMeterSystemExtension extends Extension {
    constructor(metadatas) {
        super(metadatas);
        this.timeout = 0;
    }
    enable() {
        Utils.init('extension', this, this.metadata, this.getSettings());
        this.container = new VueMeterSystemContainer();
        if (this.timeout === 0) {
            this.timeout = GLib.timeout_add(GLib.PRIORITY_DEFAULT, 1000, () => {
                if (this.container) {
                    this.container.place(this.uuid);
                }
                this.timeout = 0;
                return false;
            });
        }
    }
    disable() {
        if (this.timeout !== 0) {
            GLib.source_remove(this.timeout);
            this.timeout = 0;
        }
        try {
            this.container?.destroy();
        }
        catch (e) {
            Utils.error('Error destroying container', e);
        }
        this.container = undefined;
        Utils.release();
    }
}
