/*
 * SPDX-FileCopyrightText: 2024 Wesley Benica <wesley@benica.dev>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
import { TimeFormat } from "../core/clock_formatter.js";
/**
 * Container for localized text strings used in the text-clock extension.
 */
export class LocalizedStrings {
    /** Time expressions for format one */
    timesFormatOne;
    /** Midnight expression for format one */
    midnightFormatOne;
    /** Noon expression for format one */
    noonFormatOne;
    /** Time expressions for format two */
    timesFormatTwo;
    /** Midnight expression for format two */
    midnightFormatTwo;
    /** Noon expression for format two */
    noonFormatTwo;
    /** Month names */
    names;
    /** Weekday names with date placeholders */
    days;
    /** Plain weekday names for standalone display */
    dayNames;
    /** Date-only format template */
    dayOnly;
    /** Generic midnight expression */
    midnight;
    /** Generic noon expression */
    noon;
    /** Ordinal day names */
    daysOfMonth;
    /**
     * Creates a new WordPack with localized text strings.
     */
    constructor({ timesFormatOne, midnightFormatOne, noonFormatOne, timesFormatTwo, midnightFormatTwo, noonFormatTwo, names, days, dayNames, dayOnly, midnight, noon, daysOfMonth, }) {
        this.timesFormatOne = timesFormatOne;
        this.midnightFormatOne = midnightFormatOne;
        this.noonFormatOne = noonFormatOne;
        this.timesFormatTwo = timesFormatTwo;
        this.midnightFormatTwo = midnightFormatTwo;
        this.noonFormatTwo = noonFormatTwo;
        this.names = names;
        this.days = days;
        this.dayNames = dayNames;
        this.dayOnly = dayOnly;
        this.midnight = midnight;
        this.noon = noon;
        this.daysOfMonth = daysOfMonth;
    }
    /**
     * Get time expressions for the specified format.
     */
    getTimes(timeFormat) {
        return timeFormat === TimeFormat.FORMAT_TWO
            ? this.timesFormatTwo
            : this.timesFormatOne;
    }
}
