// src/lib/icons.ts
import Gio from "gi://Gio";
var ICONS = ["vicinae", "github"];
var Icons = class _Icons {
  static #icons = /* @__PURE__ */ new Map();
  constructor(extPath) {
    for (const name of ICONS) {
      const iconPath = `${extPath}/assets/icons/${name}.svg`;
      const icon = Gio.icon_new_for_string(iconPath);
      _Icons.#icons.set(name, icon);
    }
  }
  static get(name) {
    return _Icons.#icons.get(name);
  }
};
export {
  Icons
};
