// src/utils/dbus-utils.ts
import Gio from "gi://Gio";
var createDBusService = (interfaceDefinition, serviceObject) => {
  try {
    const dbus = Gio.DBusExportedObject.wrapJSObject(
      interfaceDefinition,
      serviceObject
    );
    return dbus;
  } catch (error) {
    throw new Error(`Failed to create D-Bus service: ${error}`);
  }
};
var exportDBusService = (dbus, path) => {
  try {
    dbus.export(Gio.DBus.session, path);
    return true;
  } catch (error) {
    throw new Error(`Failed to export D-Bus service at ${path}: ${error}`);
  }
};
var unexportDBusService = (dbus) => {
  try {
    dbus.flush();
    dbus.unexport();
    return true;
  } catch (error) {
    throw new Error(`Failed to unexport D-Bus service: ${error}`);
  }
};
export {
  createDBusService,
  exportDBusService,
  unexportDBusService
};
